/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.base;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import androidx.fragment.app.Fragment;
import androidx.viewbinding.ViewBinding;
import com.daya.orchestra.accompany.R;

public abstract class BaseFragment<V extends ViewBinding>
extends Fragment {
    protected Context mContext;
    private View rootView;
    private FrameLayout mViewStubContent;
    private ViewStub mViewStubNoData;
    private ViewStub mViewStubError;
    protected V mViewBinding;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mContext = activity;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
    }

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.acc_fragment_root, container, false);
        this.initCommonView(this.rootView);
        this.initView(this.rootView);
        this.initData();
        return this.rootView;
    }

    public void initCommonView(View view) {
        this.mViewStubContent = (FrameLayout)view.findViewById(R.id.view_stub_content);
        this.mViewStubNoData = (ViewStub)view.findViewById(R.id.view_stub_nodata);
        this.mViewStubError = (ViewStub)view.findViewById(R.id.view_stub_error);
        this.mViewBinding = this.getLayoutView();
        this.mViewStubContent.addView(this.mViewBinding.getRoot());
    }

    protected abstract V getLayoutView();

    protected abstract void initView(View var1);

    protected abstract void initData();

    public void onDetach() {
        super.onDetach();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mViewBinding != null) {
            this.mViewBinding = null;
        }
    }
}

