/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.bean.alipay;

import android.text.TextUtils;
import androidx.annotation.Keep;
import java.util.Map;

@Keep
public class AuthResult {
    private String resultStatus;
    private String result;
    private String memo;
    private String resultCode;
    private String authCode;
    private String alipayOpenId;

    public AuthResult(Map<String, String> rawResult, boolean removeBrackets) {
        String[] resultValue;
        if (rawResult == null) {
            return;
        }
        for (String key : rawResult.keySet()) {
            if (TextUtils.equals((CharSequence)key, (CharSequence)"resultStatus")) {
                this.resultStatus = rawResult.get(key);
                continue;
            }
            if (TextUtils.equals((CharSequence)key, (CharSequence)"result")) {
                this.result = rawResult.get(key);
                continue;
            }
            if (!TextUtils.equals((CharSequence)key, (CharSequence)"memo")) continue;
            this.memo = rawResult.get(key);
        }
        for (String value : resultValue = this.result.split("&")) {
            if (value.startsWith("alipay_open_id")) {
                this.alipayOpenId = this.removeBrackets(this.getValue("alipay_open_id=", value), removeBrackets);
                continue;
            }
            if (value.startsWith("auth_code")) {
                this.authCode = this.removeBrackets(this.getValue("auth_code=", value), removeBrackets);
                continue;
            }
            if (!value.startsWith("result_code")) continue;
            this.resultCode = this.removeBrackets(this.getValue("result_code=", value), removeBrackets);
        }
    }

    private String removeBrackets(String str, boolean remove) {
        if (remove && !TextUtils.isEmpty((CharSequence)str)) {
            if (str.startsWith("\"")) {
                str = str.replaceFirst("\"", "");
            }
            if (str.endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    public String toString() {
        return "authCode={" + this.authCode + "}; resultStatus={" + this.resultStatus + "}; memo={" + this.memo + "}; result={" + this.result + "}";
    }

    private String getValue(String header, String data) {
        return data.substring(header.length(), data.length());
    }

    public String getResultStatus() {
        return this.resultStatus;
    }

    public String getMemo() {
        return this.memo;
    }

    public String getResult() {
        return this.result;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getAlipayOpenId() {
        return this.alipayOpenId;
    }
}

