/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.helper;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.daya.orchestra.accompany.R;
import com.daya.orchestra.accompany.common.Config;
import com.daya.orchestra.accompany.common.SocketStatus;
import com.daya.orchestra.accompany.helper.VolumeManager;
import com.daya.orchestra.accompany.utils.ALOG;
import com.daya.orchestra.accompany.utils.Utils;
import com.daya.orchestra.accompany.widget.BaseDelayCheckView;
import com.daya.orchestra.accompany.widget.DefaultDelayCheckView;
import org.json.JSONObject;

public class DelayCheckHelper
implements View.OnClickListener {
    public static final int CHECK_EARPHONE_TIME_SPACE = 500;
    public static final int CHECK_TIME_OUT_TIME = 10000;
    public static final int SEND_CHECK_COMPLETED_TIME = 3000;
    public static final String TAG = "DelayCheckHelper";
    public static final String RECORD_END_CMD = "recordEnd";
    private BaseDelayCheckView mDelayCheckView;
    private ViewGroup groupContainer;
    private boolean isEarphoneStatusOk = false;
    private boolean isWebSocket = false;
    private OnEventListener mEventListener;
    private boolean isShow = false;
    private int checkCount = 0;
    private Handler mHandler;
    private int checkEarphoneFailCount = 0;
    private VolumeManager mVolumeManager;
    private Runnable checkStatusRunnable = new Runnable(){

        @Override
        public void run() {
            String s = Utils.checkType((Context)Utils.getApp());
            ALOG.i(DelayCheckHelper.TAG, "\u8033\u673a\u72b6\u6001:" + s);
            if (TextUtils.isEmpty((CharSequence)s)) {
                DelayCheckHelper.this.isEarphoneStatusOk = true;
                DelayCheckHelper.this.handleStartCheck();
            } else {
                DelayCheckHelper.this.checkEarphoneFailCount++;
                DelayCheckHelper.this.startCheckEarphoneRunnable(500L);
                if (DelayCheckHelper.this.checkEarphoneFailCount == 6 && DelayCheckHelper.this.mDelayCheckView != null) {
                    DelayCheckHelper.this.mDelayCheckView.showAnimStep(5);
                }
            }
        }
    };
    private Runnable checkFailRunnable = new Runnable(){

        @Override
        public void run() {
            DelayCheckHelper.this.sendCheckFailStep();
            if (DelayCheckHelper.this.mEventListener != null) {
                DelayCheckHelper.this.mEventListener.onCancelCheck();
            }
        }
    };

    public DelayCheckHelper(Handler handler) {
        this.mHandler = handler;
    }

    private void reset() {
        this.checkEarphoneFailCount = 0;
        this.isEarphoneStatusOk = false;
        this.isWebSocket = false;
        this.checkCount = 0;
    }

    private JSONObject createJson(int count) {
        try {
            JSONObject contentJson = new JSONObject();
            contentJson.put("count", count);
            contentJson.put("isAutoEnd", true);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("content", (Object)contentJson);
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void init(ViewGroup viewGroup, OnEventListener listener) {
        this.mEventListener = listener;
        this.groupContainer = viewGroup;
        this.mVolumeManager = new VolumeManager((Context)Utils.getApp());
        BaseDelayCheckView delayCheckView = Config.getInstance().getDelayCheckView(viewGroup.getContext());
        if (delayCheckView == null) {
            delayCheckView = new DefaultDelayCheckView(viewGroup.getContext());
        }
        this.mDelayCheckView = delayCheckView;
        viewGroup.removeAllViews();
        this.mDelayCheckView.setOnViewClickListener(this);
        viewGroup.addView((View)this.mDelayCheckView);
    }

    public void showDelayView() {
        if (this.groupContainer != null) {
            this.isShow = true;
            this.reset();
            this.groupContainer.setVisibility(0);
            if (this.mDelayCheckView != null) {
                this.mDelayCheckView.showAnimStep(0);
            }
            this.startCheckEarphoneRunnable(0L);
            this.startWebSocketCheck();
        }
    }

    private void handleStartCheck() {
        if (!this.checkInit()) {
            return;
        }
        ALOG.i(TAG, "handleStartCheck:isEarphoneStatusOk---" + this.isEarphoneStatusOk + "--isWebSocket:" + this.isWebSocket);
        if (this.isEarphoneStatusOk && this.isWebSocket) {
            this.changeVolume();
            this.goStartTune();
            if (this.mDelayCheckView != null) {
                this.mDelayCheckView.showAnimStep(1);
            }
        }
    }

    private void changeVolume() {
        if (this.mVolumeManager != null) {
            int max = this.mVolumeManager.getMaxMusicVolume();
            this.mVolumeManager.setCurrentMusicVolume(max);
        }
    }

    private void goStartTune() {
        if (this.mEventListener != null) {
            this.mEventListener.goStartTune(this.createJson(this.checkCount));
            this.sendCheckTimeOutRunnable();
        }
    }

    private void startWebSocketCheck() {
        if (!this.checkInit()) {
            return;
        }
        SocketStatus webSocketStatus = this.mEventListener.getWebSocketStatus();
        ALOG.i(TAG, "startWebSocketCheck:" + webSocketStatus.getDes());
        if (webSocketStatus == SocketStatus.CONNECTED) {
            this.isWebSocket = true;
            this.handleStartCheck();
        }
    }

    private void startCheckEarphoneRunnable(long delay) {
        if (!this.checkInit()) {
            return;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.checkStatusRunnable);
            this.mHandler.postDelayed(this.checkStatusRunnable, delay);
        }
    }

    public void notifyWebSocketConnected() {
        if (!this.checkInit()) {
            return;
        }
        ALOG.i(TAG, "notifyWebSocketConnected");
        this.isWebSocket = true;
        this.handleStartCheck();
    }

    public void closeDelay() {
        if (!this.checkInit()) {
            return;
        }
        this.hideDelayView();
        this.sendDismissMsg();
    }

    private void hideDelayView() {
        if (this.groupContainer != null) {
            this.isShow = false;
            this.groupContainer.setVisibility(8);
        }
    }

    private void sendDismissMsg() {
        if (this.mEventListener != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                JSONObject contentJson = new JSONObject();
                jsonObject.put("api", (Object)"cancelDelayCheck");
                jsonObject.put("content", (Object)contentJson);
                this.mEventListener.sendWebViewMsg(jsonObject.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (Utils.isFastClick(500L)) {
            return;
        }
        if (id2 == R.id.iv_close) {
            this.hideDelayView();
            this.sendDismissMsg();
            if (this.mEventListener != null) {
                this.mEventListener.onCancelCheck();
            }
            return;
        }
        if (id2 == R.id.view_retry) {
            this.showDelayView();
            return;
        }
    }

    public void release() {
        if (this.mDelayCheckView != null) {
            this.mDelayCheckView.release();
        }
    }

    public boolean parseServerMsg(String serverMsg) {
        if (!this.checkInit()) {
            return false;
        }
        try {
            ++this.checkCount;
            this.removeRunnable();
            if (this.mEventListener != null) {
                ALOG.i(TAG, "\u68c0\u6d4b\u5b8c\u6210:" + this.checkCount);
                if (this.checkCount >= 2) {
                    ALOG.i(TAG, "\u4e24\u6b21\u68c0\u6d4b\u5b8c\u6210");
                    this.mEventListener.toFinishTune();
                } else {
                    this.goStartTune();
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void removeRunnable() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.checkFailRunnable);
        }
    }

    private void sendCheckTimeOutRunnable() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.checkFailRunnable);
            this.mHandler.postDelayed(this.checkFailRunnable, 10000L);
        }
    }

    public void setCheckResult(boolean isSuccess) {
        if (!this.checkInit()) {
            return;
        }
        this.removeRunnable();
        if (this.mDelayCheckView != null) {
            this.mDelayCheckView.showAnimStep(isSuccess ? 2 : 3);
        }
        if (isSuccess) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (DelayCheckHelper.this.mDelayCheckView != null) {
                        DelayCheckHelper.this.mDelayCheckView.showAnimStep(4);
                    }
                    DelayCheckHelper.this.sendCheckCompletedMsg();
                }
            }, 3000L);
        }
    }

    private void sendCheckCompletedMsg() {
        if (this.mHandler != null) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (DelayCheckHelper.this.mEventListener != null) {
                        DelayCheckHelper.this.mEventListener.sendWebViewMsg(DelayCheckHelper.this.getCheckCompletedMsg());
                    }
                    DelayCheckHelper.this.hideDelayView();
                }
            }, 1000L);
        }
    }

    private String getCheckCompletedMsg() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("api", (Object)"finishDelayCheck");
            JSONObject contentJson = new JSONObject();
            jsonObject.put("content", (Object)contentJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    private void sendCheckFailStep() {
        if (this.mDelayCheckView != null) {
            this.mDelayCheckView.showAnimStep(3);
        }
    }

    private boolean checkInit() {
        return this.isShow;
    }

    public static interface OnEventListener {
        public SocketStatus getWebSocketStatus();

        public void goStartTune(JSONObject var1);

        public void toFinishTune();

        public void sendWebViewMsg(String var1);

        public void onCancelCheck();
    }
}

