/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.recorder;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Build;
import com.daya.orchestra.accompany.recorder.AudioRecordConfig;
import com.daya.orchestra.accompany.recorder.PullTransport;
import com.daya.orchestra.accompany.recorder.Recorder;
import com.daya.orchestra.accompany.utils.ALOG;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BaseDataRecorder
implements Recorder {
    protected PullTransport pullTransport;
    protected AudioRecordConfig config;
    protected int bufferSizeInBytes;
    protected float bufferDuration;
    protected File file;
    private AudioRecord audioRecord;
    private OutputStream outputStream;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    protected BaseDataRecorder(File file, AudioRecordConfig config, PullTransport pullTransport) {
        this.file = file;
        this.config = config;
        this.pullTransport = pullTransport;
        this.bufferSizeInBytes = AudioRecord.getMinBufferSize((int)config.getSampleRateInHz(), (int)config.getChannelConfig(), (int)config.getAudioFormat());
        float durationUnit = config.getSampleRateInHz() * config.bitsPerSample() / 8;
        this.bufferDuration = (float)this.bufferSizeInBytes / durationUnit * 1000.0f;
        ALOG.i("BaseData", "bufferDuration:" + this.bufferDuration);
        ALOG.i("BaseData", "bufferSizeInBytes:" + this.bufferSizeInBytes);
    }

    @Override
    public void startRecording(final Context context) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                BaseDataRecorder.this.startRecord(context);
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void startRecord(Context context) {
        try {
            if (this.audioRecord == null) {
                this.audioRecord = new AudioRecord(this.config.getAudioSource(), this.config.getSampleRateInHz(), this.config.getChannelConfig(), this.config.getAudioFormat(), this.bufferSizeInBytes);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                AudioManager audioManager = (AudioManager)context.getSystemService("audio");
                for (AudioDeviceInfo device : audioManager.getDevices(1)) {
                    if (15 != device.getType()) continue;
                    this.audioRecord.setPreferredDevice(device);
                    break;
                }
            }
            if (this.outputStream == null) {
                this.outputStream = new FileOutputStream(this.file);
            }
            this.audioRecord.startRecording();
            this.pullTransport.isEnableToBePulled(true);
            this.pullTransport.startPoolingAndWriting(this.audioRecord, this.bufferSizeInBytes, this.outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pauseRecording() {
        this.pullTransport.isEnableToBePulled(false);
    }

    @Override
    public void resumeRecording(Context context) {
        this.startRecording(context);
    }

    @Override
    public void stopRecording() {
        this.pauseRecording();
        try {
            if (this.audioRecord != null) {
                if (this.audioRecord.getState() == 1) {
                    this.audioRecord.stop();
                }
                this.audioRecord.release();
                this.audioRecord = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                this.outputStream.close();
                this.outputStream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public float getBufferDuration() {
        return this.bufferDuration;
    }
}

