/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.widget;

import android.app.Dialog;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.daya.orchestra.accompany.R;
import com.daya.orchestra.accompany.utils.DensityUtil;
import com.daya.orchestra.accompany.widget.ViewHolder;

public abstract class BaseDialog
extends DialogFragment {
    private static final String MARGIN = "margin";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DIM = "dim_amount";
    private static final String GRAVITY = "gravity";
    private static final String CANCEL = "out_cancel";
    private static final String THEME = "theme";
    private static final String ANIM = "anim_style";
    private static final String LAYOUT = "layout_id";
    private int margin;
    private int width;
    private int height;
    private float dimAmount = 0.5f;
    private int gravity = 17;
    private boolean outCancel = true;
    @StyleRes
    protected int theme = R.style.ac_basedialog;
    @StyleRes
    private int animStyle;
    @LayoutRes
    protected int layoutId;

    public abstract int intLayoutId();

    public abstract void convertView(ViewHolder var1, BaseDialog var2);

    public int initTheme() {
        return this.theme;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, this.initTheme());
        if (savedInstanceState != null) {
            this.margin = savedInstanceState.getInt(MARGIN);
            this.width = savedInstanceState.getInt(WIDTH);
            this.height = savedInstanceState.getInt(HEIGHT);
            this.dimAmount = savedInstanceState.getFloat(DIM);
            this.gravity = savedInstanceState.getInt(GRAVITY);
            this.outCancel = savedInstanceState.getBoolean(CANCEL);
            this.theme = savedInstanceState.getInt(THEME);
            this.animStyle = savedInstanceState.getInt(ANIM);
            this.layoutId = savedInstanceState.getInt(LAYOUT);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.layoutId = this.intLayoutId();
        View view = inflater.inflate(this.layoutId, container, false);
        this.convertView(ViewHolder.create(view), this);
        return view;
    }

    public void onStart() {
        super.onStart();
        this.initParams();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(MARGIN, this.margin);
        outState.putInt(WIDTH, this.width);
        outState.putInt(HEIGHT, this.height);
        outState.putFloat(DIM, this.dimAmount);
        outState.putInt(GRAVITY, this.gravity);
        outState.putBoolean(CANCEL, this.outCancel);
        outState.putInt(THEME, this.theme);
        outState.putInt(ANIM, this.animStyle);
        outState.putInt(LAYOUT, this.layoutId);
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.initParams();
    }

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        Dialog dialog = new Dialog(this.requireContext(), this.getTheme());
        this.hideNavigationBar(dialog.getWindow());
        this.adjustFullScreen(dialog.getWindow());
        return dialog;
    }

    private void initParams() {
        Window window = this.getDialog().getWindow();
        if (window != null) {
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.dimAmount = this.dimAmount;
            if (this.gravity != 0) {
                lp.gravity = this.gravity;
            }
            switch (this.gravity) {
                case 3: 
                case 51: 
                case 83: {
                    if (this.animStyle != 0) break;
                    this.animStyle = R.style.ac_leftanimation;
                    break;
                }
                case 48: {
                    if (this.animStyle != 0) break;
                    this.animStyle = R.style.ac_topanimation;
                    break;
                }
                case 5: 
                case 53: 
                case 85: {
                    if (this.animStyle != 0) break;
                    this.animStyle = R.style.ac_rightanimation;
                    break;
                }
                case 80: {
                    if (this.animStyle != 0) break;
                    this.animStyle = R.style.ac_bottomanimation;
                    break;
                }
            }
            lp.width = this.width == 0 ? DensityUtil.getScreenWidth(this.getContext()) - 2 * DensityUtil.dp2px(this.getContext(), this.margin) : (this.width == -1 ? -2 : DensityUtil.dp2px(this.getContext(), this.width));
            lp.height = this.height == 0 ? -2 : (this.height == -1 ? -1 : DensityUtil.dp2px(this.getContext(), this.height));
            window.setWindowAnimations(this.animStyle);
            window.setAttributes(lp);
        }
        this.setCancelable(this.outCancel);
    }

    private void hideNavigationBar(Window window) {
        int uiOptions = 2822;
        if (window == null) {
            return;
        }
        window.getDecorView().setSystemUiVisibility(uiOptions);
    }

    public void adjustFullScreen(Window window) {
        if (window == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            window.setAttributes(lp);
            View decorView = window.getDecorView();
            decorView.setSystemUiVisibility(1280);
        }
    }

    public BaseDialog setMargin(int margin) {
        this.margin = margin;
        return this;
    }

    public BaseDialog setWidth(int width) {
        this.width = width;
        return this;
    }

    public BaseDialog setHeight(int height) {
        this.height = height;
        return this;
    }

    public BaseDialog setDimAmount(float dimAmount) {
        this.dimAmount = dimAmount;
        return this;
    }

    public BaseDialog setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public BaseDialog setOutCancel(boolean outCancel) {
        this.outCancel = outCancel;
        return this;
    }

    public BaseDialog setAnimStyle(@StyleRes int animStyle) {
        this.animStyle = animStyle;
        return this;
    }

    public BaseDialog show(FragmentManager manager) {
        FragmentTransaction ft = manager.beginTransaction();
        if (this.isAdded()) {
            ft.remove((Fragment)this).commit();
        }
        ft.add((Fragment)this, String.valueOf(System.currentTimeMillis()));
        ft.addToBackStack(null);
        ft.commitAllowingStateLoss();
        return this;
    }
}

