/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.uniapp.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.DrawFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.uniapp.ui.shadow.UniBoxShadowData;
import io.dcloud.feature.uniapp.ui.shadow.UniBoxShadowOptions;
import io.dcloud.feature.uniapp.ui.shadow.UniInsetBoxShadowDrawable;
import io.dcloud.feature.uniapp.ui.shadow.UniInsetBoxShadowLayer;
import io.dcloud.feature.uniapp.ui.shadow.UniNormalBoxShadowDrawable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UniBoxShadowUtil {
    private static final String TAG = "UniBoxShadowUtil";
    private static boolean sBoxShadowEnabled = true;
    private static Pattern sColorPattern;

    public static void setBoxShadowEnabled(boolean enabled) {
        sBoxShadowEnabled = enabled;
        WXLogUtils.w(TAG, "Switch box-shadow status: " + enabled);
    }

    public static boolean isBoxShadowEnabled() {
        return sBoxShadowEnabled;
    }

    public static UniBoxShadowData parseBoxShadow(int width, int height, String style, float[] radii, float viewPort, float quality) {
        if (!sBoxShadowEnabled) {
            WXLogUtils.w(TAG, "box-shadow was disabled by config");
            return null;
        }
        UniBoxShadowOptions[] shadows = UniBoxShadowUtil.parseBoxShadows(style, viewPort);
        if (shadows == null || shadows.length == 0) {
            WXLogUtils.w(TAG, "Failed to parse box-shadow: " + style);
            return null;
        }
        ArrayList<UniBoxShadowOptions> normalShadows = new ArrayList<UniBoxShadowOptions>();
        ArrayList<UniBoxShadowOptions> insetShadows = new ArrayList<UniBoxShadowOptions>();
        for (UniBoxShadowOptions shadow : shadows) {
            if (shadow == null) continue;
            if (shadow.isInset) {
                insetShadows.add(0, shadow);
                continue;
            }
            normalShadows.add(0, shadow);
        }
        if (radii != null && radii.length != 8) {
            WXLogUtils.w(TAG, "Length of radii must be 8");
        }
        UniBoxShadowData data = new UniBoxShadowData(normalShadows, insetShadows, radii, quality);
        data.setStyle(style);
        if (normalShadows.size() > 0) {
            int maxWidth = 0;
            int maxHeight = 0;
            for (UniBoxShadowOptions option : normalShadows) {
                option.viewWidth = width;
                option.viewHeight = height;
                option.radii = radii;
                Rect rect = option.getTargetCanvasRect();
                if (maxWidth < rect.width()) {
                    maxWidth = rect.width();
                }
                if (maxHeight >= rect.height()) continue;
                maxHeight = rect.height();
            }
            data.setNormalMaxWidth(maxWidth);
            data.setNormalMaxHeight(maxHeight);
            data.setNormalLeft(maxWidth - width);
            data.setNormalTop(maxHeight - height);
        }
        data.setContentHeight(height);
        data.setContentWidth(width);
        return data;
    }

    public static UniBoxShadowOptions[] parseBoxShadows(String boxShadowStyle, float viewport) {
        if (sColorPattern == null) {
            sColorPattern = Pattern.compile("([rR][gG][bB][aA]?)\\((\\d+\\s*),\\s*(\\d+\\s*),\\s*(\\d+\\s*)(?:,\\s*(\\d+(?:\\.\\d+)?))?\\)");
        }
        Matcher matcher = sColorPattern.matcher(boxShadowStyle);
        String processedStyle = boxShadowStyle;
        while (matcher.find()) {
            String color2 = matcher.group();
            processedStyle = processedStyle.replace(color2, "#" + StringUtil.format((String)"%8s", (Object[])new Object[]{Integer.toHexString(WXResourceUtils.getColor(color2, -16777216))}).replaceAll("\\s", "0"));
        }
        String[] styles = processedStyle.split(",");
        if (styles != null && styles.length > 0) {
            UniBoxShadowOptions[] result = new UniBoxShadowOptions[styles.length];
            for (int i = 0; i < styles.length; ++i) {
                result[i] = UniBoxShadowUtil.parseBoxShadow(styles[i], viewport);
            }
            return result;
        }
        return null;
    }

    private static UniBoxShadowOptions parseBoxShadow(String boxShadow, float viewport) {
        ArrayList<String> params;
        String maybeColor;
        UniBoxShadowOptions result = new UniBoxShadowOptions(viewport);
        if (TextUtils.isEmpty((CharSequence)boxShadow)) {
            return null;
        }
        String boxShadowCopy = boxShadow;
        if ((boxShadowCopy = boxShadowCopy.replaceAll("\\s*,\\s+", ",")).contains("inset")) {
            result.isInset = true;
            boxShadowCopy = boxShadowCopy.replace("inset", "");
        }
        if (!TextUtils.isEmpty((CharSequence)(maybeColor = (String)(params = new ArrayList<String>(Arrays.asList((boxShadowCopy = boxShadowCopy.trim()).split("\\s+")))).get(params.size() - 1))) && (maybeColor.startsWith("#") || maybeColor.startsWith("rgb") || WXResourceUtils.isNamedColor(maybeColor))) {
            result.color = WXResourceUtils.getColor(maybeColor, -16777216);
            params.remove(params.size() - 1);
        }
        try {
            float px;
            if (params.size() < 2) {
                return null;
            }
            if (!TextUtils.isEmpty((CharSequence)((CharSequence)params.get(0)))) {
                px = WXUtils.getFloat(((String)params.get(0)).trim(), Float.valueOf(0.0f)).floatValue();
                result.hShadow = WXViewUtils.getRealSubPxByWidth(px, viewport);
            }
            if (!TextUtils.isEmpty((CharSequence)((CharSequence)params.get(1)))) {
                px = WXUtils.getFloat(((String)params.get(1)).trim(), Float.valueOf(0.0f)).floatValue();
                result.vShadow = WXViewUtils.getRealPxByWidth(px, viewport);
            }
            for (int i = 2; i < params.size(); ++i) {
                int parserIndex = i - 2;
                UniBoxShadowOptions.IParser parser = result.optionParamParsers.get(parserIndex);
                parser.parse((String)params.get(i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return result;
    }

    public static UniNormalBoxShadowDrawable getNormalBoxShadowDrawable(UniBoxShadowData shadowData, Resources resources) {
        if (shadowData.getNormalShadows().size() <= 0) {
            return null;
        }
        int canvasWidth = shadowData.getCanvasWidth();
        int canvasHeight = shadowData.getCanvasHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)canvasWidth, (int)canvasHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        if (Build.VERSION.SDK_INT >= 19) {
            Logger.e((String)TAG, (String)("Allocation memory for box-shadow: " + bitmap.getAllocationByteCount() / 1024 + " KB"));
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        for (UniBoxShadowOptions option : shadowData.getNormalShadows()) {
            UniBoxShadowOptions scaledOption = option.scale(shadowData.getQuality());
            UniBoxShadowUtil.drawShadow(canvas, scaledOption, shadowData.getNormalTop(), shadowData.getNormalLeft(), shadowData.getQuality());
        }
        UniNormalBoxShadowDrawable drawable2 = new UniNormalBoxShadowDrawable(resources, bitmap);
        return drawable2;
    }

    private static void drawShadow(Canvas canvas, UniBoxShadowOptions options, float normalTop, float normalLeft, float quality) {
        float borderRadius;
        RectF shadowRect = new RectF(0.0f, 0.0f, (float)options.viewWidth + 2.0f * options.spread, (float)options.viewHeight + 2.0f * options.spread);
        float shadowDx = options.blur;
        float shadowDy = options.blur;
        shadowDx = options.hShadow >= 0.0f ? (shadowDx += 2.0f * options.hShadow) : 0.0f;
        shadowDy = options.vShadow >= 0.0f ? (shadowDy += 2.0f * options.vShadow) : 0.0f;
        shadowRect.offset(shadowDx, shadowDy);
        Path contentPath = new Path();
        RectF clipRect = new RectF(0.0f, 0.0f, (float)options.viewWidth, (float)options.viewHeight);
        float dy = 0.0f;
        float dx = 0.0f;
        if (normalTop > 0.0f) {
            dy = normalTop * quality / 2.0f;
        }
        if (normalLeft > 0.0f) {
            dx = normalLeft * quality / 2.0f;
        }
        clipRect.offset(dx, dy);
        clipRect.inset(1.0f, 1.0f);
        contentPath.addRoundRect(clipRect, options.radii, Path.Direction.CCW);
        canvas.clipPath(contentPath, Region.Op.DIFFERENCE);
        Paint shadowPaint = new Paint();
        shadowPaint.setAntiAlias(true);
        shadowPaint.setColor(options.color);
        shadowPaint.setStyle(Paint.Style.FILL);
        if (options.blur > 0.0f) {
            shadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(options.blur, BlurMaskFilter.Blur.NORMAL));
        }
        if ((borderRadius = options.radii[0]) == options.radii[2] && borderRadius == options.radii[4] && borderRadius == options.radii[6]) {
            canvas.drawRoundRect(shadowRect, borderRadius, borderRadius, shadowPaint);
        } else {
            Path shadowPath = new Path();
            float[] shadowRadii = new float[8];
            for (int i = 0; i < options.radii.length; ++i) {
                float contentRadius = options.radii[i];
                shadowRadii[i] = contentRadius == 0.0f ? 0.0f : options.radii[i] + options.spread;
            }
            shadowPath.addRoundRect(shadowRect, shadowRadii, Path.Direction.CW);
            canvas.drawPath(shadowPath, shadowPaint);
        }
    }

    public static UniInsetBoxShadowLayer getInsetBoxShadowDrawable(UniBoxShadowData shadowData) {
        if (shadowData.getInsetShadows().size() <= 0) {
            return null;
        }
        UniInsetBoxShadowLayer insetShadow = null;
        if (Build.VERSION.SDK_INT >= 18) {
            Drawable[] drawables = new Drawable[shadowData.getInsetShadows().size()];
            for (int i = 0; i < shadowData.getInsetShadows().size(); ++i) {
                UniBoxShadowOptions option = shadowData.getInsetShadows().get(i);
                UniInsetBoxShadowDrawable insetBoxShadowDrawable = new UniInsetBoxShadowDrawable(shadowData.getContentWidth(), shadowData.getContentHeight(), option.hShadow, option.vShadow, option.blur, option.spread, option.color, shadowData.getRadii());
                drawables[i] = insetBoxShadowDrawable;
            }
            insetShadow = new UniInsetBoxShadowLayer(drawables);
        } else {
            WXLogUtils.w(TAG, "Call setInsetBoxShadow() requires API level 18 or higher.");
        }
        return insetShadow;
    }
}

