/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.storage;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.util.Map;
import java.util.Set;

@JNINamespace(value="liteav")
public class PersistStorage {
    public static final String GLOBAL_DOMAIN = "com.liteav.storage.global";
    private final SharedPreferences mSharedPreferences;
    private final SharedPreferences.Editor mEditor;

    @SuppressLint(value={"CommitPrefEdits"})
    @CalledByNative
    public PersistStorage(String domain) {
        this.mSharedPreferences = ContextUtils.getApplicationContext().getSharedPreferences(domain, 0);
        this.mEditor = this.mSharedPreferences.edit();
    }

    @CalledByNative
    public void put(String key, int value) {
        this.mEditor.putInt(key, value);
    }

    @CalledByNative
    public void put(String key, long value) {
        this.mEditor.putLong(key, value);
    }

    @CalledByNative
    public void put(String key, String value) {
        this.mEditor.putString(key, value);
    }

    @CalledByNative
    public void clear(String key) {
        this.mEditor.remove(key);
    }

    @CalledByNative
    public void commit() {
        this.mEditor.commit();
    }

    @CalledByNative
    public Integer getInt(String key) {
        Integer n2;
        if (!this.mSharedPreferences.contains(key)) {
            return null;
        }
        try {
            n2 = this.mSharedPreferences.getInt(key, -1);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return n2;
    }

    @CalledByNative
    public Long getLong(String key) {
        Long l2;
        if (!this.mSharedPreferences.contains(key)) {
            return null;
        }
        try {
            l2 = this.mSharedPreferences.getLong(key, -1L);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return l2;
    }

    @CalledByNative
    public String getString(String key) {
        String string;
        if (!this.mSharedPreferences.contains(key)) {
            return null;
        }
        try {
            string = this.mSharedPreferences.getString(key, null);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return string;
    }

    @CalledByNative
    public String[] getAllKeys() {
        Map map = this.mSharedPreferences.getAll();
        if (map == null || map.isEmpty()) {
            return new String[0];
        }
        Set set = map.keySet();
        String[] stringArray = new String[set.size()];
        return set.toArray(stringArray);
    }

    @CalledByNative
    public static int integerToBase(Integer in) {
        return in;
    }

    @CalledByNative
    public static long longToBase(Long in) {
        return in;
    }
}

