/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.opengl.GLES20;
import com.daasuu.mp4compose.filter.GlFilter;

public class GlVignetteFilter
extends GlFilter {
    private static final String FRAGMENT_SHADER = "precision mediump float;varying vec2 vTextureCoord;uniform lowp sampler2D sTexture;uniform lowp vec2 vignetteCenter;uniform highp float vignetteStart;uniform highp float vignetteEnd;void main() {lowp vec3 rgb = texture2D(sTexture, vTextureCoord).rgb;lowp float d = distance(vTextureCoord, vec2(vignetteCenter.x, vignetteCenter.y));lowp float percent = smoothstep(vignetteStart, vignetteEnd, d);gl_FragColor = vec4(mix(rgb.x, 0.0, percent), mix(rgb.y, 0.0, percent), mix(rgb.z, 0.0, percent), 1.0);}";
    private float vignetteCenterX = 0.5f;
    private float vignetteCenterY = 0.5f;
    private float vignetteStart = 0.2f;
    private float vignetteEnd = 0.85f;

    public GlVignetteFilter() {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", FRAGMENT_SHADER);
    }

    public float getVignetteStart() {
        return this.vignetteStart;
    }

    public void setVignetteStart(float vignetteStart) {
        this.vignetteStart = vignetteStart;
    }

    public float getVignetteEnd() {
        return this.vignetteEnd;
    }

    public void setVignetteEnd(float vignetteEnd) {
        this.vignetteEnd = vignetteEnd;
    }

    @Override
    public void onDraw() {
        GLES20.glUniform2f((int)this.getHandle("vignetteCenter"), (float)this.vignetteCenterX, (float)this.vignetteCenterY);
        GLES20.glUniform1f((int)this.getHandle("vignetteStart"), (float)this.vignetteStart);
        GLES20.glUniform1f((int)this.getHandle("vignetteEnd"), (float)this.vignetteEnd);
    }
}

