/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.daasuu.mp4compose.filter.GlOverlayFilter;

public class GlWatermarkFilter
extends GlOverlayFilter {
    private Bitmap bitmap;
    private Position position = Position.LEFT_TOP;

    public GlWatermarkFilter(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public GlWatermarkFilter(Bitmap bitmap, Position position) {
        this.bitmap = bitmap;
        this.position = position;
    }

    @Override
    protected void drawCanvas(Canvas canvas) {
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            switch (this.position) {
                case LEFT_TOP: {
                    canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
                    break;
                }
                case LEFT_BOTTOM: {
                    canvas.drawBitmap(this.bitmap, 0.0f, (float)(canvas.getHeight() - this.bitmap.getHeight()), null);
                    break;
                }
                case RIGHT_TOP: {
                    canvas.drawBitmap(this.bitmap, (float)(canvas.getWidth() - this.bitmap.getWidth()), 0.0f, null);
                    break;
                }
                case RIGHT_BOTTOM: {
                    canvas.drawBitmap(this.bitmap, (float)(canvas.getWidth() - this.bitmap.getWidth()), (float)(canvas.getHeight() - this.bitmap.getHeight()), null);
                }
            }
        }
    }

    public static enum Position {
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

