/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module.ping;

import android.text.TextUtils;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.ping.IHeartBeatProcess;
import cn.rongcloud.rtc.module.ping.RTCPingManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.RongCoreClient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class TimerHeartBeat
implements IHeartBeatProcess {
    RTCPingManager mPingManager;
    private static final String TAG = "TimerHeartBeat";
    Map<Integer, HeartBeatInfo> mHeartBeatInfoContainer = new ConcurrentHashMap<Integer, HeartBeatInfo>();
    long forceConnectBeforeTime = 15000L;
    long quitBeforeTime = 5000L;
    volatile boolean isReleased = false;

    @Override
    public void release() {
        this.isReleased = true;
    }

    public TimerHeartBeat(RTCPingManager pingManager) {
        this.mPingManager = pingManager;
        Class<?> clazz = IMLibRTCClient.getInstance().getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("SetRTCHeartbeatListenerEx", Object.class);
            if (null == method) {
                Object[] objectArray = new Object[2];
                objectArray[0] = "SetRTCHeartbeatListenerEx";
                objectArray[1] = "method is null";
                ReportUtil.libError(ReportUtil.TAG.TIMERHEARTBEAT, "task|reason", objectArray);
                return;
            }
            method.invoke((Object)IMLibRTCClient.getInstance(), new HeartbeatListener(){

                @Override
                public void OnRTCHeartbeat(int code, String roomId) {
                }

                @Override
                public void OnRTCHeartbeatSend(String roomId, int seqId) {
                    if (TimerHeartBeat.this.isReleased) {
                        return;
                    }
                    HeartBeatInfo.HeartBeatInfoBuilder builder = new HeartBeatInfo.HeartBeatInfoBuilder();
                    builder.setId(seqId).setPingTime(System.currentTimeMillis());
                    HeartBeatInfo heartBeatInfo = builder.build();
                    TimerHeartBeat.this.mHeartBeatInfoContainer.put(seqId, heartBeatInfo);
                    TimerHeartBeat.this.forceConnectAndQuit(roomId);
                }

                @Override
                public void OnRTCHeartbeatWithSeqId(int code, String roomId, int seqId) {
                    if (TimerHeartBeat.this.isReleased) {
                        return;
                    }
                    if (code == 0) {
                        HeartBeatInfo heartBeatInfo = TimerHeartBeat.this.mHeartBeatInfoContainer.get(seqId);
                        if (null != heartBeatInfo) {
                            long pongDurationTime = 0L;
                            pongDurationTime = System.currentTimeMillis() - heartBeatInfo.pingTime;
                            if (pongDurationTime < (long)TimerHeartBeat.this.mPingManager.mOfflineKickTime) {
                                TimerHeartBeat.this.mHeartBeatInfoContainer.remove(seqId);
                                for (Integer key : TimerHeartBeat.this.mHeartBeatInfoContainer.keySet()) {
                                    HeartBeatInfo info = TimerHeartBeat.this.mHeartBeatInfoContainer.get(key);
                                    if (info.pingTime > heartBeatInfo.pingTime) continue;
                                    TimerHeartBeat.this.mHeartBeatInfoContainer.remove(key);
                                }
                            } else {
                                ReportUtil.libError(ReportUtil.TAG.TIMERHEARTBEAT, "task|reason", "OnRTCHeartbeatWithSeqId", "PongTime overtime");
                            }
                        }
                        int pingErrorCode = TimerHeartBeat.this.mPingManager.getPINGErrorCode(roomId);
                        int pingFailedCount = TimerHeartBeat.this.mPingManager.getPingFailedCount(roomId);
                        if (pingErrorCode != 0) {
                            FinLog.e(TimerHeartBeat.TAG, "sendRTCPing.Success :  mPingErrorCode : " + pingErrorCode + " , roomId :" + roomId + " , MainRoomId :" + TimerHeartBeat.this.mPingManager.mMainRoomId);
                        } else {
                            FinLog.v(TimerHeartBeat.TAG, "sendRTCPing.Success : " + roomId + " , MainRoomId :" + TimerHeartBeat.this.mPingManager.mMainRoomId);
                        }
                        TimerHeartBeat.this.mPingManager.clearHearbeatInfo(roomId);
                        if (!(pingFailedCount < TimerHeartBeat.this.mPingManager.maxFailureNumber || TextUtils.equals((CharSequence)roomId, (CharSequence)TimerHeartBeat.this.mPingManager.mMainRoomId) || pingErrorCode != IRongCoreEnum.CoreErrorCode.RC_NET_CHANNEL_INVALID.getValue() && pingErrorCode != IRongCoreEnum.CoreErrorCode.RC_MSG_RESP_TIMEOUT.getValue())) {
                            TimerHeartBeat.this.mPingManager.otherRoomConnectedError(roomId, pingErrorCode);
                            return;
                        }
                        if (TextUtils.equals((CharSequence)roomId, (CharSequence)TimerHeartBeat.this.mPingManager.mMainRoomId) && (pingErrorCode == IRongCoreEnum.CoreErrorCode.RC_NET_CHANNEL_INVALID.getValue() || pingErrorCode == IRongCoreEnum.CoreErrorCode.RC_MSG_RESP_TIMEOUT.getValue())) {
                            RTCEngineImpl.getInstance().sendMessage(8000, new Object[0]);
                        }
                    } else {
                        RTCErrorCode errorCode = RTCErrorCode.valueOf(code);
                        int pingErrorCode = errorCode.getValue();
                        TimerHeartBeat.this.mPingManager.updateHeartbeatInfo(roomId, pingErrorCode);
                        int pingFailedCount = TimerHeartBeat.this.mPingManager.getPingFailedCount(roomId);
                        FinLog.e(TimerHeartBeat.TAG, "sendRTCPing() error =  " + pingErrorCode + " , pingFailedCount :" + pingFailedCount + " , netWorkAvailable = " + TimerHeartBeat.this.mPingManager.isNetWorkAvailable() + " ,IM connectionStatus = " + RongCoreClient.getInstance().getCurrentConnectionStatus() + " , roomID :" + roomId + " , EnableAutoReconnect :" + TimerHeartBeat.this.mPingManager.mEnableAutoReconnect + " , MainRoomId \uff1a" + TimerHeartBeat.this.mPingManager.mMainRoomId);
                        if (pingFailedCount >= TimerHeartBeat.this.mPingManager.maxFailureNumber && !TextUtils.equals((CharSequence)roomId, (CharSequence)TimerHeartBeat.this.mPingManager.mMainRoomId)) {
                            TimerHeartBeat.this.mPingManager.otherRoomConnectedError(roomId, pingErrorCode);
                            return;
                        }
                        HeartBeatInfo heartBeatInfo = TimerHeartBeat.this.mHeartBeatInfoContainer.get(seqId);
                        if (null == heartBeatInfo) {
                            HeartBeatInfo.HeartBeatInfoBuilder builder = new HeartBeatInfo.HeartBeatInfoBuilder();
                            builder.setId(seqId).setPingTime(System.currentTimeMillis());
                            HeartBeatInfo info = builder.build();
                            TimerHeartBeat.this.mHeartBeatInfoContainer.put(seqId, info);
                        }
                        if (TextUtils.equals((CharSequence)roomId, (CharSequence)TimerHeartBeat.this.mPingManager.mMainRoomId)) {
                            if (TimerHeartBeat.this.mPingManager.mEnableAutoReconnect) {
                                if (RongCoreClient.getInstance().getCurrentConnectionStatus() == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED && (errorCode.getValue() == 40001 || errorCode.getValue() == RTCErrorCode.RongRTCCodeNoMatchedRoom.getValue())) {
                                    TimerHeartBeat.this.mPingManager.clearHearbeatInfo(roomId);
                                    RTCEngineImpl.getInstance().sendMessage(8101, new Object[0]);
                                }
                            } else {
                                TimerHeartBeat.this.forceConnectAndQuit(roomId);
                            }
                        }
                    }
                }
            });
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private boolean checkIsForceConnect() {
        boolean ret = false;
        if (RongCoreClient.getInstance().getCurrentConnectionStatus() == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED) {
            return false;
        }
        for (Integer key : this.mHeartBeatInfoContainer.keySet()) {
            HeartBeatInfo info = this.mHeartBeatInfoContainer.get(key);
            if (System.currentTimeMillis() - info.pingTime < (long)this.mPingManager.mOfflineKickTime - this.forceConnectBeforeTime) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private boolean checkIsQuit() {
        boolean ret = false;
        if (this.mPingManager.mEnableAutoReconnect) {
            return false;
        }
        for (Integer key : this.mHeartBeatInfoContainer.keySet()) {
            HeartBeatInfo info = this.mHeartBeatInfoContainer.get(key);
            if (System.currentTimeMillis() - info.pingTime < (long)this.mPingManager.mOfflineKickTime - this.quitBeforeTime) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void forceConnectAndQuit(String roomId) {
        if (this.checkIsQuit()) {
            this.mPingManager.clearHearbeatInfo(roomId);
            FinLog.e(TAG, "The number of heartbeats has arrived.");
            this.mPingManager.stopPing();
            ReportUtil.libError(ReportUtil.TAG.PINGFAILED4TIMESLEAVEROOM, "roomId", this.mPingManager.mMainRoomId);
            RTCEngineImpl.getInstance().sendMessage(9001, new Object[0]);
            String reason = "PongTime overtime";
            ReportUtil.libStatus(ReportUtil.TAG.TIMERHEARTBEAT, "task|reason", "quit", reason);
            return;
        }
        if (this.checkIsForceConnect()) {
            this.mPingManager.forceConnect();
            String reason = "PongTime overtime";
            ReportUtil.libStatus(ReportUtil.TAG.TIMERHEARTBEAT, "task|reason", "forceConnect", reason);
        }
    }

    static class HeartBeatInfo {
        int id = 0;
        long pingTime = 0L;
        long pongTime = 0L;
        int errorCode = 0;

        HeartBeatInfo() {
        }

        void setPongTime(long pongTime) {
            this.pongTime = pongTime;
        }

        public static class HeartBeatInfoBuilder {
            int id;
            long pingTime;
            long pongTime;
            int errorCode;

            HeartBeatInfo build() {
                HeartBeatInfo heartBeatInfo = new HeartBeatInfo();
                heartBeatInfo.id = this.id;
                heartBeatInfo.pingTime = this.pingTime;
                heartBeatInfo.pongTime = this.pongTime;
                heartBeatInfo.errorCode = this.errorCode;
                return heartBeatInfo;
            }

            HeartBeatInfoBuilder setId(int id) {
                this.id = id;
                return this;
            }

            HeartBeatInfoBuilder setPingTime(long pingTime) {
                this.pingTime = pingTime;
                return this;
            }

            HeartBeatInfoBuilder setPongTime(long pongTime) {
                this.pongTime = pongTime;
                return this;
            }

            HeartBeatInfoBuilder setErrorCode(int errorCode) {
                this.errorCode = errorCode;
                return this;
            }
        }
    }

    static interface HeartbeatListener {
        public void OnRTCHeartbeat(int var1, String var2);

        public void OnRTCHeartbeatSend(String var1, int var2);

        public void OnRTCHeartbeatWithSeqId(int var1, String var2, int var3);
    }
}

