/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.jni.video;

import cn.rongcloud.rtc.base.RCRTCRect;
import cn.rongcloud.rtc.jni.video.InternalRect;
import cn.rongcloud.rtc.jni.video.ScreenOrientationMode;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import java.nio.ByteBuffer;

public class RCWaterMarkFilter {
    private String TAG = "RCWaterMarkFilter";
    private long nativeWatermarkJni = 0L;
    private int preWidth;
    private int preHeight;
    private String waterIconPath;
    private InternalRect preLogoRect;
    private final Object lock = new Object();

    public boolean isInitWatermarkEnv() {
        return this.nativeWatermarkJni != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWatermarkParams(String waterPath, RCRTCRect rect, int iconWidth, int iconHeight) {
        Object object = this.lock;
        synchronized (object) {
            this.waterIconPath = waterPath;
            this.preLogoRect = new InternalRect(rect.x, rect.y, rect.width, iconWidth, iconHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initWatermarkEnv(int width, int height) {
        this.preWidth = width;
        this.preHeight = height;
        Object object = this.lock;
        synchronized (object) {
            this.nativeWatermarkJni = this.nativeInitWatermarkEnv(width, height, this.waterIconPath, this.preLogoRect);
            RLog.d((String)this.TAG, (String)("- initWatermarkEnv: nativeWatermarkJni:" + this.nativeWatermarkJni));
            return this.nativeWatermarkJni != 0L;
        }
    }

    private ScreenOrientationMode getScreenOrientation(int rotation) {
        ScreenOrientationMode mode = rotation == 270 || rotation == 90 ? ScreenOrientationMode.SCREEN_ORIENTATION_PORTRAIT : (rotation == 0 || rotation == 180 ? ScreenOrientationMode.SCREEN_ORIENTATION_LANDSCAPE : ScreenOrientationMode.SCREEN_ORIENTATION_PORTRAIT);
        return mode;
    }

    public boolean reInitWatermarkEnv(int curWidth, int curHeight, int rotation) {
        ScreenOrientationMode mode = this.getScreenOrientation(rotation);
        if (mode == ScreenOrientationMode.SCREEN_ORIENTATION_LANDSCAPE) {
            int t = curWidth;
            curWidth = curHeight;
            curHeight = t;
        }
        boolean ret = true;
        if (this.preWidth != curWidth || this.preHeight != curHeight) {
            RLog.d((String)this.TAG, (String)String.format("- reInitFFmpegEnv: preWidth:%d, prevHeight:%d, curWidth:%d, curHeight:%d", this.preWidth, this.preHeight, curWidth, curHeight));
            if (this.isInitWatermarkEnv()) {
                this.destroyWatermarkEnv();
            }
            ret = this.initWatermarkEnv(curWidth, curHeight);
            ReportUtil.libStatus(ReportUtil.TAG.REINITWATERMARKENV, "status|mode|result", new Object[]{"- setAudioDualMonoMode", mode, ret});
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drawWatermark(ByteBuffer yBuffer, ByteBuffer uBuffer, ByteBuffer vBuffer, int width, int height, int rotation) {
        ScreenOrientationMode mode = this.getScreenOrientation(rotation);
        if (mode == ScreenOrientationMode.SCREEN_ORIENTATION_LANDSCAPE) {
            int t = width;
            width = height;
            height = t;
        }
        Object object = this.lock;
        synchronized (object) {
            int ret = -1;
            if (this.nativeWatermarkJni != 0L) {
                ret = this.nativeDrawWatermark(this.nativeWatermarkJni, yBuffer, uBuffer, vBuffer, width, height);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyWatermarkEnv() {
        Object object = this.lock;
        synchronized (object) {
            if (this.nativeWatermarkJni != 0L) {
                RLog.d((String)this.TAG, (String)("- destroyWatermarkEnv: nativeWatermarkJni:" + this.nativeWatermarkJni));
                this.nativeDestroyWatermarkEnv(this.nativeWatermarkJni);
            }
            this.nativeWatermarkJni = 0L;
            this.preWidth = 0;
            this.preHeight = 0;
        }
        ReportUtil.libStatus(ReportUtil.TAG.DESTROYWATERMARKENV, "status|wmJni", "- destroyWatermarkEnv", this.nativeWatermarkJni);
    }

    private native long nativeInitWatermarkEnv(int var1, int var2, String var3, InternalRect var4);

    private native int nativeDrawWatermark(long var1, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5, int var6, int var7);

    private native void nativeDestroyWatermarkEnv(long var1);
}

