/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.proxy.message.messagebeans;

import android.os.Parcel;
import android.os.Parcelable;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import io.rong.common.ParcelUtils;

public class UserState
implements Parcelable {
    private String userId;
    private State state;
    private String sourceRoomId;
    private int switchRoleType = -1;
    public static final Parcelable.Creator<UserState> CREATOR = new Parcelable.Creator<UserState>(){

        public UserState createFromParcel(Parcel source) {
            return new UserState(source);
        }

        public UserState[] newArray(int size) {
            return new UserState[size];
        }
    };

    public UserState() {
    }

    public UserState(String userId, State state, String sourceRoomId, int switchRoleType) {
        this.userId = userId;
        this.state = state;
        this.sourceRoomId = sourceRoomId;
        this.switchRoleType = switchRoleType;
    }

    public UserState(Parcel in) {
        this.setUserId(ParcelUtils.readFromParcel((Parcel)in));
        this.setState(State.valueOf(ParcelUtils.readIntFromParcel((Parcel)in)));
        this.setSourceRoomId(ParcelUtils.readFromParcel((Parcel)in));
        this.setRole(ParcelUtils.readIntFromParcel((Parcel)in));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.userId);
        dest.writeInt(this.state.getValue());
        dest.writeString(this.sourceRoomId);
        dest.writeInt(this.switchRoleType);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getSourceRoomId() {
        return this.sourceRoomId;
    }

    public void setSourceRoomId(String sourceRoomId) {
        this.sourceRoomId = sourceRoomId;
    }

    public int getRole() {
        return this.switchRoleType;
    }

    public RCRTCLiveRole getLiveRole() {
        if (this.switchRoleType == 1) {
            return RCRTCLiveRole.AUDIENCE;
        }
        if (this.switchRoleType == 2) {
            return RCRTCLiveRole.BROADCASTER;
        }
        return null;
    }

    public void setRole(int role) {
        this.switchRoleType = role;
    }

    public static enum State {
        NONE(-1),
        JOIN(0),
        LEFT(1),
        OFFLINE(2);

        int value;

        public static State valueOf(int value) {
            for (State type : State.values()) {
                if (value != type.value) continue;
                return type;
            }
            return NONE;
        }

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

