/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc.probe;

import android.graphics.ImageFormat;
import android.os.SystemClock;
import cn.rongcloud.rtc.api.probe.RTCProbeConfig;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.core.NV21Buffer;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSource;
import cn.rongcloud.rtc.core.VideoSourceObserver;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import cn.rongcloud.rtc.webrtc.probe.RTCProbeBaseStream;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class RTCProbeVideoStream
extends RTCProbeBaseStream
implements ILocalVideoStreamResource {
    private static final int CACHE_FRAME_COUNT = 2;
    private final Random random = new Random();
    private byte[][] cacheBuffer;
    private int frameIndex = 0;
    private Timer timer;
    private VideoSourceObserver capturerObserver;
    private final int fps;

    public RTCProbeVideoStream(String userId, RTCProbeConfig config) {
        super(userId, RCRTCMediaType.VIDEO, config);
        this.fps = config.getVideoFps().getFps();
    }

    @Override
    public void start() {
        FinLog.d("RTCProbeTest", "[start] ==> ");
        super.start();
        VideoSource videoSource = ((VideoTrack)this.track).getVideoSource();
        this.capturerObserver = videoSource.getCapturerObserver();
        int width = this.config.getWidth();
        int height = this.config.getHeight();
        int chromaHeight = (height + 1) / 2;
        int uvStride = width / 2;
        int uvSize = uvStride * chromaHeight;
        int yEnd = width * height;
        int vPos = yEnd + uvSize;
        int frameSize = yEnd * ImageFormat.getBitsPerPixel((int)17) / 8;
        this.cacheBuffer = new byte[2][frameSize];
        byte[] temp = new byte[uvSize];
        for (int i = 0; i < 2; ++i) {
            byte[] bytes = this.cacheBuffer[i];
            this.random.nextBytes(temp);
            System.arraycopy(temp, 0, bytes, yEnd, uvSize);
            this.random.nextBytes(temp);
            System.arraycopy(temp, 0, bytes, vPos, uvSize);
        }
        this.onStartTimer();
    }

    @Override
    public void release() {
        FinLog.d("RTCProbeTest", "[release] ==> ");
        super.release();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.capturerObserver = null;
    }

    private void onStartTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RTCProbeVideoStream.this.onWriteData();
            }
        }, 0L, (long)(1000 / this.fps));
    }

    private void onWriteData() {
        VideoSourceObserver capturerObserver = this.capturerObserver;
        if (capturerObserver == null) {
            return;
        }
        this.frameIndex %= 2;
        byte[] cache = this.cacheBuffer[this.frameIndex];
        NV21Buffer frameBuffer = new NV21Buffer(cache, this.config.getWidth(), this.config.getHeight(), new Runnable(){

            @Override
            public void run() {
            }
        });
        capturerObserver.onFrameCaptured(new VideoFrame(frameBuffer, 0, TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime())));
        ++this.frameIndex;
    }

    @Override
    public int getWidth() {
        return this.config.getWidth();
    }

    @Override
    public int getHeight() {
        return this.config.getHeight();
    }

    @Override
    public int getMinBitrate() {
        return this.config.getMinBitRate();
    }

    @Override
    public int getMaxBitrate() {
        return this.config.getMaxBitRate();
    }

    @Override
    public RCRTCParamsType.RCRTCVideoFps getVideoFps() {
        return this.config.getVideoFps();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    @Override
    public RCRTCStreamType getStreamType() {
        return RCRTCStreamType.NORMAL;
    }

    @Override
    public boolean isPreserved() {
        return false;
    }
}

