/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.taobao.weex.IWXInstanceContainerOnSizeListener;
import com.taobao.weex.IWXRenderListener;
import com.taobao.weex.R;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import com.taobao.weex.utils.tools.LogDetail;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IActivityHandler;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IEventCallback;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ITitleNView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaContainerFrameItem;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.ui.AdaUniWebView;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.webview.WebResUtil;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.ErrorDialogUtil;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.common.util.TitleNViewUtil;
import io.dcloud.common.util.language.LanguageUtil;
import io.dcloud.feature.internal.sdk.SDK;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.weex.WXAnalyzerDelegate;
import io.dcloud.feature.weex.WXBaseWrapper;
import io.dcloud.feature.weex.WeexInstanceMgr;
import io.dcloud.feature.weex_scroller.view.DCWXScrollView;
import io.dcloud.weex.WXDotDataUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

class WXViewWrapper
extends WXBaseWrapper
implements IWXRenderListener,
IEventCallback,
WeexInstanceMgr.IWXStatisticsCallBack {
    String TAG = "WXViewWrapper";
    View mWXSDKView;
    long lastTime = 0L;
    JSONObject jsonObject;
    boolean isService = false;
    static final int LOAD_JS = 1000;
    List<FireEvent> mFireCaches;
    private String readyJs = ";var plusModule = weex.requireModule('plus'); plusModule.uniReady();";
    boolean isReady = false;
    float mViewPort;
    int mFontSize = -1;
    JSONObject mNvueCfgData = null;
    boolean isDelayRender = false;
    private List<Message> mRenderCaches = new ArrayList<Message>();
    private List<Message> mWaitServiceRenderList = new ArrayList<Message>();
    private boolean isFrameShow = false;
    private boolean isChlid = false;
    private boolean isPre = false;
    private boolean isCompilerWithUniapp = true;
    LogDetail mServiceLogDetail;
    private String mUniPagePath;
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1000: {
                    if (WXViewWrapper.this.isService) {
                        if (WXViewWrapper.this.mWebview == null) {
                            return;
                        }
                        String nvueLaunchMode = WXViewWrapper.this.mWebview.obtainApp().obtainConfigProperty("nvueLaunchMode");
                        if (!TextUtils.isEmpty((CharSequence)nvueLaunchMode) && nvueLaunchMode.equals("fast") && WeexInstanceMgr.self().getControl().equals("uni-v3") && !WXEnvironment.sRemoteDebugMode) {
                            JSONObject jsonObject = WXViewWrapper.this.mWebview.obtainApp().obtainThridInfo(IApp.ConfigProperty.ThridInfo.LaunchWebviewJsonData);
                            if (jsonObject != null && jsonObject.has("uniNView")) {
                                WXViewWrapper.this.delayedRender(msg.obj, 100L);
                            } else {
                                WXViewWrapper.this.delayedRender(msg.obj, 10L);
                            }
                            return;
                        }
                        WXViewWrapper.this.delayedRender(msg.obj, 10L);
                        break;
                    }
                    int delay = 10;
                    WXViewWrapper.this.delayedRender(msg.obj, delay);
                }
            }
        }
    };
    IWXInstanceContainerOnSizeListener mInstanceOnSizeListener = new IWXInstanceContainerOnSizeListener(){

        @Override
        public void onSizeChanged(String instanceId, float defaultWidth, float defaultHeight, boolean isWidthWrapContent, boolean isHeightWrapContent) {
            WXViewWrapper.this.updateDeviceDisplay(defaultWidth, defaultHeight, isWidthWrapContent, isHeightWrapContent);
        }
    };
    private boolean hasScrollListener = false;
    long time = 0L;
    private float mLastScreenWidth = 0.0f;

    public List<Message> getWaitServiceRenderList() {
        return this.mWaitServiceRenderList;
    }

    @Override
    public void onReady() {
        this.isReady = true;
        this.runFireCache();
        if (this.isService) {
            if (!SDK.isUniMPSDK()) {
                Object[] objects = new Object[]{this.mWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "onUniMPInit", new Object[0]};
                WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, objects);
            }
            if (this.mServiceLogDetail != null) {
                this.mServiceLogDetail.taskEnd();
                WXDotDataUtil.setValue(this.mServiceLogDetail.info.taskName, this.mServiceLogDetail.time.execTime);
            }
        }
    }

    private synchronized void runFireCache() {
        if (!this.mFireCaches.isEmpty()) {
            for (int i = 0; i < this.mFireCaches.size(); ++i) {
                FireEvent fireEvent = this.mFireCaches.get(i);
                this.fireGlobalEvent(fireEvent.key, fireEvent.params);
            }
            this.mFireCaches.clear();
        }
    }

    WXViewWrapper(IWebview webview, ViewGroup viewGroup, JSONObject jsonObject, String wxId, int zIndex, boolean isPre) {
        super(viewGroup.getContext());
        this.lastTime = System.currentTimeMillis();
        Logger.e((String)this.TAG, (String)("WXViewWrapper----------isPre=" + isPre + "  wxid=" + wxId));
        if (!WeexInstanceMgr.self().isJsFrameworkReady()) {
            WeexInstanceMgr.self().setWXStatisticsCallBack(this);
        }
        this.isCompilerWithUniapp = !WeexInstanceMgr.self().getComplier().equalsIgnoreCase("weex");
        this.mWebview = webview;
        this.isPre = isPre;
        this.mFireCaches = new ArrayList<FireEvent>();
        if (this.mWebview instanceof AdaUniWebView) {
            this.isService = ((AdaUniWebView)this.mWebview).isUniService();
        }
        if (WeexInstanceMgr.self().isJSFKFileNotFound()) {
            boolean isVue3 = WeexInstanceMgr.self().getVueVersion() == 3;
            String message = StringUtil.format((String)webview.getContext().getString(R.string.dcloud_feature_weex_jsfk_not_found_tips), (Object[])new Object[]{isVue3 ? "VUE3" : "VUE2"});
            ErrorDialogUtil.showErrorTipsAlert((Activity)webview.getActivity(), (String)message, (DialogInterface.OnClickListener)new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Process.killProcess((int)Process.myPid());
                }
            });
            return;
        }
        viewGroup.addView((View)this, zIndex, new ViewGroup.LayoutParams(-1, -1));
        AdaFrameView frameView = (AdaFrameView)this.mWebview.obtainFrameView();
        frameView.addFrameViewListener((IEventCallback)this);
        this.jsonObject = jsonObject;
        this.lastTime = System.currentTimeMillis();
        this.mWxId = wxId;
        this.mNvueCfgData = JSONUtil.createJSONObject((String)this.mWebview.obtainApp().obtainConfigProperty("uni_nvue_data"));
    }

    private Map<String, Object> getInitOptions() {
        int p;
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.mWebview != null) {
            options.put("plus_appid", this.mWebview.obtainApp().obtainAppId());
        }
        if (this.mWebview != null) {
            options.put("plus_web_id", this.mWebview.obtainFrameId());
        }
        String bundleUrl = this.mSrcPath;
        if (!TextUtils.isEmpty((CharSequence)this.mPath) && bundleUrl.indexOf("?") == -1 && (p = this.mPath.indexOf("?")) > 0) {
            bundleUrl = bundleUrl + this.mPath.substring(p);
        }
        options.put("deviceLanguage", LanguageUtil.getDeviceDefLocalLanguage());
        options.put("isInternational", PdrUtil.checkIntl());
        options.put("bundleUrl", bundleUrl);
        if (this.getWxId().equals("__uniapp__service")) {
            options.put("plus_weex_id", "__uniapp__service");
        }
        return options;
    }

    public String getSrcPath() {
        return this.mSrcPath;
    }

    public String getWxId() {
        return this.mWxId;
    }

    private String getInitStringJsonData() {
        JSONObject jsonObject = new JSONObject();
        try {
            String href = this.mWebview.getOriginalUrl();
            if (href.startsWith("file://")) {
                href = href.substring("file://".length());
            }
            href = this.mWebview.obtainApp().convert2RelPath(href);
            jsonObject.put("Plus_InitURL", (Object)href);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    @Override
    public String evalJs(String js, int type) {
        if (this.mWXSDKInstance != null) {
            return WXBridgeManager.getInstance().syncExecJsOnInstanceWithResult(this.mWXSDKInstance.getInstanceId(), js, type);
        }
        return "";
    }

    private void render(Object template, Map<String, Object> options, String jsonInitData) {
        if (this.mWXSDKInstance != null) {
            this.recoveryInstance();
        }
        if (this.mWebview == null || this.mWebview.obtainFrameView() == null) {
            return;
        }
        if (this.isService && BaseInfo.SyncDebug) {
            if (this.mServiceLogDetail == null) {
                this.mServiceLogDetail = new LogDetail();
                this.mServiceLogDetail.name("initV3Service");
            }
            this.mServiceLogDetail.taskStart();
        }
        this.isChlid = ((AdaFrameView)this.mWebview.obtainFrameView()).isChildOfFrameView;
        this.isReady = false;
        if (this.isPre) {
            if (WeexInstanceMgr.self().getPreInstanceId() != null) {
                this.mWXSDKInstance = WXSDKManager.getInstance().getSDKInstance(WeexInstanceMgr.self().getPreInstanceId());
                if (this.mWXSDKInstance != null) {
                    this.mWXSDKInstance.init(this.mWebview.getContext());
                    this.onReady();
                    this.fireGlobalEvent("launchApp", new HashMap<String, Object>());
                }
            }
        } else {
            String replaceTemplate = (String)template;
            if (!WXEnvironment.sRemoteDebugMode) {
                replaceTemplate = replaceTemplate.replaceFirst(Pattern.quote("\"use weex:vue\""), Matcher.quoteReplacement(""));
            }
            template = replaceTemplate + this.readyJs;
        }
        if (!this.isPre) {
            this.mWXSDKInstance = this.mWebview.getActivity() instanceof IActivityHandler ? new UniSDKInstance(this.mWebview.getContext(), ((IActivityHandler)this.mWebview.getActivity()).getOriginalContext()) : new UniSDKInstance(this.mWebview.getContext());
        }
        if (this.mFontSize > 0) {
            this.mWXSDKInstance.setDefaultFontSize(this.mFontSize);
        }
        this.mWXSDKInstance.setPageKeepRawCssStyles();
        this.mWXSDKInstance.setImmersive(this.mWebview.obtainApp().obtainStatusBarMgr().isImmersive);
        this.mWXAnaly = new WXAnalyzerDelegate(this.mWebview.getContext());
        this.mWXSDKInstance.registerRenderListener(this);
        this.mWXSDKInstance.setBundleUrl(this.mSrcPath);
        this.mWXSDKInstance.setUniPagePath(this.isService ? "uni-service" : this.mUniPagePath);
        this.mWXSDKInstance.setWXInstanceContainerOnSizeListener(this.mInstanceOnSizeListener);
        ((UniSDKInstance)this.mWXSDKInstance).setCompilerWithUniapp(this.isCompilerWithUniapp);
        int frameType = this.mWebview.obtainFrameView().getFrameType();
        if ((this.isFrameShow || frameType == 2 || frameType == 4) && this.mWXSDKInstance != null) {
            this.mWXSDKInstance.onShowAnimationEnd();
        }
        if (!this.isPre) {
            this.mWXSDKInstance.render(this.mWxId, String.valueOf(template), options, jsonInitData, WXRenderStrategy.APPEND_ASYNC);
        }
        if (!this.isService && this.mWebview instanceof AdaWebview) {
            ((AdaWebview)this.mWebview).dispatchWebviewStateEvent(0, (Object)this.mPath);
        }
        this.initViewPortWidth(false);
        this.initFlexDirection();
        this.initTitleNView();
        if (this.isService) {
            WeexInstanceMgr.self().setUniServiceCreated(true, this.mWebview.obtainApp());
        }
    }

    private void initTitleNView() {
        AdaFrameView frame = (AdaFrameView)this.mWebview.obtainFrameView();
        JSONObject titleNView = frame.obtainFrameOptions().titleNView;
        if (null != titleNView && !frame.isChildOfFrameView && titleNView.has("type") && "transparent".equals(titleNView.optString("type"))) {
            this.mWXSDKInstance.addOnInstanceVisibleListener(new WXSDKInstance.OnInstanceVisibleListener(){

                @Override
                public void onAppear() {
                    WXViewWrapper.this.addScrollListener(this);
                }

                @Override
                public void onDisappear() {
                }
            });
        }
    }

    public void addScrollListener(WXSDKInstance.OnInstanceVisibleListener listener) {
        boolean isTab;
        if (this.mWXSDKInstance == null || this.mWXSDKInstance.getRootView() == null) {
            return;
        }
        if (this.hasScrollListener) {
            return;
        }
        this.hasScrollListener = true;
        final AdaFrameView frame = (AdaFrameView)this.mWebview.obtainFrameView();
        ViewOptions options = frame.obtainFrameOptions();
        ViewOptions paremtoptions = frame.obtainWebviewParent().obtainFrameOptions();
        JSONObject titleNView = options.titleNView;
        if (titleNView == null && paremtoptions.titleNView != null) {
            titleNView = paremtoptions.titleNView;
        }
        if (titleNView == null || !titleNView.has("type")) {
            return;
        }
        AdaContainerFrameItem parentFrame = frame.getParentFrameItem();
        boolean bl = isTab = parentFrame instanceof AdaFrameView && ((AdaFrameView)parentFrame).obtainWebView() != null && "tab".equals(((AdaFrameView)parentFrame).obtainWebView().obtainFrameId());
        if (null != titleNView && (!frame.isChildOfFrameView || isTab) && titleNView.has("type") && "transparent".equals(titleNView.optString("type"))) {
            if (this.mWXSDKInstance == null) {
                return;
            }
            View root = this.mWXSDKInstance.getRootView();
            if (root != null && listener != null) {
                this.mWXSDKInstance.removeOnInstanceVisibleListener(listener);
            }
            final JSONObject finalTitleNView = titleNView;
            if (root instanceof DCWXScrollView) {
                ((DCWXScrollView)root).addScrollViewListener(new DCWXScrollView.WXScrollViewListener(){

                    @Override
                    public void onScrollChanged(DCWXScrollView scrollView, int x, int t, int oldx, int oldt) {
                        if (frame == null || finalTitleNView == null) {
                            return;
                        }
                        int coverage = frame.obtainFrameOptions().coverage;
                        if (coverage < oldt && coverage < t) {
                            return;
                        }
                        Object titleNViewObj = TitleNViewUtil.getTitleNView((AbsMgr)frame.obtainWindowMgr(), (IWebview)frame.obtainWebView(), (IFrameView)frame, (String)TitleNViewUtil.getTitleNViewId((IFrameView)frame));
                        if (titleNViewObj instanceof ITitleNView) {
                            TitleNViewUtil.updateTitleNViewStatus((ITitleNView)((ITitleNView)titleNViewObj), (IWebview)frame.obtainWebView(), (float)t, (JSONObject)finalTitleNView, (float)coverage);
                        }
                    }

                    @Override
                    public void onScrollToBottom(DCWXScrollView scrollView, int x, int y) {
                    }

                    @Override
                    public void onScrollToTop(DCWXScrollView scrollView, int x, int y) {
                    }

                    @Override
                    public void onScrollStopped(DCWXScrollView scrollView, int x, int y) {
                    }

                    @Override
                    public void onScroll(DCWXScrollView scrollView, int x, int y) {
                    }
                });
            } else if (root instanceof WXScrollView) {
                ((WXScrollView)root).addScrollViewListener(new WXScrollView.WXScrollViewListener(){

                    @Override
                    public void onScrollChanged(WXScrollView scrollView, int x, int t, int oldx, int oldt) {
                        if (frame == null || finalTitleNView == null) {
                            return;
                        }
                        int coverage = frame.obtainFrameOptions().coverage;
                        if (coverage < oldt && coverage < t) {
                            return;
                        }
                        Object titleNViewObj = TitleNViewUtil.getTitleNView((AbsMgr)frame.obtainWindowMgr(), (IWebview)frame.obtainWebView(), (IFrameView)frame, (String)TitleNViewUtil.getTitleNViewId((IFrameView)frame));
                        if (titleNViewObj instanceof ITitleNView) {
                            TitleNViewUtil.updateTitleNViewStatus((ITitleNView)((ITitleNView)titleNViewObj), (IWebview)frame.obtainWebView(), (float)t, (JSONObject)finalTitleNView, (float)coverage);
                        }
                    }

                    @Override
                    public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
                    }

                    @Override
                    public void onScrollStopped(WXScrollView scrollView, int x, int y) {
                    }

                    @Override
                    public void onScroll(WXScrollView scrollView, int x, int y) {
                    }
                });
            } else if (root instanceof BounceRecyclerView) {
                ((WXRecyclerView)((BounceRecyclerView)root).getInnerView()).addOnScrollListener(new RecyclerView.OnScrollListener(){
                    int oldx;
                    int oldy;

                    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                        int oldX = this.oldx;
                        int oldY = this.oldy;
                        this.oldx += dx;
                        this.oldy += dy;
                        if (frame == null || finalTitleNView == null) {
                            return;
                        }
                        int coverage = frame.obtainFrameOptions().coverage;
                        if (coverage < oldY && coverage < this.oldy) {
                            return;
                        }
                        Object titleNViewObj = TitleNViewUtil.getTitleNView((AbsMgr)frame.obtainWindowMgr(), (IWebview)frame.obtainWebView(), (IFrameView)frame, (String)TitleNViewUtil.getTitleNViewId((IFrameView)frame));
                        if (titleNViewObj instanceof ITitleNView) {
                            TitleNViewUtil.updateTitleNViewStatus((ITitleNView)((ITitleNView)titleNViewObj), (IWebview)frame.obtainWebView(), (float)this.oldy, (JSONObject)finalTitleNView, (float)coverage);
                        }
                    }
                });
            }
        }
    }

    @Override
    protected void onRefresh() {
        if (this.mWebview != null) {
            ((AdaFrameView)this.mWebview.obtainFrameView()).dispatchFrameViewEvents("pulldownrefreshevent", (Object)3);
            ((AdaFrameView)this.mWebview.obtainFrameView()).dispatchFrameViewEvents("pullToRefresh", (Object)3);
        }
    }

    @Override
    public void loadTemplate(JSONObject info) {
        try {
            JSONObject data;
            this.jsonObject = info;
            this.mPath = info.optString("js");
            if (this.jsonObject != null && this.jsonObject.has("data") && (data = this.jsonObject.optJSONObject("data")) != null) {
                this.mFontSize = data.optInt("defaultFontSize");
                if (data.has("delayRender")) {
                    this.isDelayRender = data.optBoolean("delayRender", this.isDelayRender);
                }
                if (data.has("path")) {
                    this.mUniPagePath = data.optString("path", "");
                }
            }
            if (!PdrUtil.isNetPath((String)this.mPath)) {
                this.mSrcPath = this.initSrcPath(this.mPath);
                if (this.isPre) {
                    this.render(null, this.getInitOptions(), this.getInitStringJsonData());
                    return;
                }
                ThreadPool.self().addThreadTask(new Runnable(){

                    @Override
                    public void run() {
                        if (WXViewWrapper.this.mWebview == null) {
                            return;
                        }
                        InputStream is = WebResUtil.getEncryptionInputStream((String)WXViewWrapper.this.mSrcPath, (IApp)WXViewWrapper.this.mWebview.obtainApp());
                        if (is != null) {
                            try {
                                String template = new String(IOUtil.toString((InputStream)is));
                                if (WXViewWrapper.this.isService) {
                                    template = WXViewWrapper.this.getAllUniService(template);
                                }
                                Message message = new Message();
                                message.obj = template;
                                message.what = 1000;
                                if (!WXViewWrapper.this.isService && !WeexInstanceMgr.self().isUniServiceCreated(WXViewWrapper.this.mWebview.obtainApp())) {
                                    if (!WXViewWrapper.this.mWaitServiceRenderList.contains(message)) {
                                        WXViewWrapper.this.mWaitServiceRenderList.add(message);
                                    }
                                } else if (!WeexInstanceMgr.self().isJsFrameworkReady()) {
                                    if (!WXViewWrapper.this.mRenderCaches.contains(message)) {
                                        WXViewWrapper.this.mRenderCaches.add(message);
                                    }
                                } else if (WXViewWrapper.this.isDelayRender && !WXViewWrapper.this.isService && !WXViewWrapper.this.isFrameShow) {
                                    if (!WXViewWrapper.this.mRenderCaches.contains(message)) {
                                        WXViewWrapper.this.mRenderCaches.add(message);
                                    }
                                } else {
                                    WXViewWrapper.this.mHandler.sendMessage(message);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            IOUtil.close((InputStream)is);
                        }
                    }
                }, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void titleNViewRefresh() {
        this.addScrollListener(null);
    }

    private String getAllUniService(String template) {
        if (this.mWebview == null || this.mWebview.obtainApp() == null) {
            return "";
        }
        IApp app = this.mWebview.obtainApp();
        String path = this.initSrcPath("_www/app-config.js");
        String confusion = this.initSrcPath("_www/app-confusion.js");
        InputStream is = WebResUtil.getEncryptionInputStream((String)path, (IApp)app);
        InputStream confusionStream = WebResUtil.getEncryptionInputStream((String)confusion, (IApp)app);
        try {
            String configJs = IOUtil.toString((InputStream)is);
            String confusionJs = IOUtil.toString((InputStream)confusionStream);
            template = configJs + confusionJs + template;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return template;
    }

    private void delayedRender(final Object template, long delayMilllis) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WXViewWrapper.this.mWebview == null) {
                    return;
                }
                WXViewWrapper.this.render(template, WXViewWrapper.this.getInitOptions(), WXViewWrapper.this.getInitStringJsonData());
            }
        }, delayMilllis);
    }

    public String initSrcPath(String path) {
        if (this.mWebview == null) {
            return path;
        }
        int s = path.indexOf("?");
        String p = path;
        if (s > 1) {
            p = path.substring(0, s);
        }
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        String srcPath = p;
        String[] exName = path.split("\\.");
        if (exName.length == 1) {
            srcPath = srcPath + ".js";
        } else if (exName.length == 2) {
            srcPath = exName[0] + ".js";
        }
        File file = new File(srcPath);
        if (file.exists()) {
            return Uri.fromFile((File)file).toString();
        }
        byte mode = this.mWebview.obtainApp().obtainRunningAppMode();
        String baseUrl = null;
        if (!(this.mWebview instanceof AdaUniWebView)) {
            baseUrl = this.mWebview.obtainFullUrl();
        }
        if (!srcPath.startsWith("/storage") && mode == 1) {
            String url = this.mWebview.obtainApp().convert2AbsFullPath(baseUrl, srcPath);
            if (url.startsWith("/")) {
                url = url.substring(1, url.length());
            }
            srcPath = url;
        } else {
            srcPath = this.mWebview.obtainApp().convert2WebviewFullPath(baseUrl, srcPath);
        }
        return srcPath;
    }

    @Override
    public void onViewCreated(WXSDKInstance instance, View view) {
        if (this.mWXAnaly != null) {
            this.mWXAnaly.onWeexViewCreated(instance, view);
        }
        this.mWXSDKView = view;
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        this.addView(this.mWXSDKView, (ViewGroup.LayoutParams)layoutParams);
        if (this.isFocusableInTouchMode()) {
            this.mWXSDKView.setFocusable(true);
            this.mWXSDKView.setFocusableInTouchMode(true);
        }
        this.addScrollListener(null);
    }

    public void setFocusable(int focusable) {
        super.setFocusable(focusable);
        if (this.mWXSDKView != null) {
            this.mWXSDKView.setFocusable(focusable);
        }
    }

    public void setFocusableInTouchMode(boolean focusableInTouchMode) {
        super.setFocusableInTouchMode(focusableInTouchMode);
        if (this.mWXSDKView != null) {
            this.mWXSDKView.setFocusableInTouchMode(focusableInTouchMode);
        }
    }

    @Override
    public void onRenderSuccess(WXSDKInstance instance, int width, int height) {
        if (this.mWXAnaly != null) {
            this.mWXAnaly.onWeexRenderSuccess(instance);
        }
        if (!this.isService && this.mWebview != null) {
            boolean isAuto;
            String str_auto;
            if (this.mWebview instanceof AdaWebview) {
                ((AdaWebview)this.mWebview).dispatchWebviewStateEvent(1, (Object)this.mPath);
            }
            if (PdrUtil.isEmpty((Object)(str_auto = this.mWebview.obtainApp().obtainConfigProperty("autoclose")))) {
                str_auto = "true";
            }
            if (isAuto = Boolean.parseBoolean(str_auto)) {
                this.mWebview.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.WindowMgr, 11, (Object)this.mWebview.obtainFrameView());
            }
        }
    }

    @Override
    public void onRefreshSuccess(WXSDKInstance instance, int width, int height) {
    }

    @Override
    public void onException(WXSDKInstance instance, String errCode, String msg) {
        Logger.e((String)this.TAG, (String)("onException--errCode=" + errCode + "    msg=" + msg));
        if (this.mWXAnaly != null) {
            this.mWXAnaly.onException(instance, errCode, msg);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        WeexInstanceMgr.self().unWXStatisticsCallBack(this);
        this.mWebview = null;
    }

    @Override
    public void reload() {
        if (this.time != 0L && System.currentTimeMillis() - this.time < 600L) {
            return;
        }
        this.time = System.currentTimeMillis();
        this.recoveryInstance();
        this.isFrameShow = true;
        if (!TextUtils.isEmpty((CharSequence)this.mPath)) {
            this.loadTemplate(this.jsonObject);
        }
    }

    @Override
    public String getType() {
        return "view";
    }

    public Object onCallBack(String pEventType, Object pArgs) {
        if (PdrUtil.isEquals((String)pEventType, (String)"close") && pArgs instanceof IWebview) {
            ((AdaFrameView)((IWebview)pArgs).obtainFrameView()).removeFrameViewListener((IEventCallback)this);
            WeexInstanceMgr.self().removeWeexView(this.mWxId);
            this.onDestroy();
        } else if ((PdrUtil.isEquals((String)pEventType, (String)"show_animation_end") || PdrUtil.isEquals((String)pEventType, (String)"child_initialize_show")) && !this.isFrameShow) {
            this.isFrameShow = true;
            if (this.mWXSDKInstance != null) {
                this.mWXSDKInstance.onShowAnimationEnd();
            }
            if (this.isDelayRender) {
                this.runDelayedRenderCaches(this.mRenderCaches);
            }
        }
        return null;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mWXSDKInstance != null && this.mWebview.getActivity() != null) {
            int angle = this.mWebview.getActivity().getWindowManager().getDefaultDisplay().getRotation();
            int orientation = 0;
            String value = "portrait";
            switch (angle) {
                case 1: {
                    orientation = 90;
                    value = "landscape";
                    break;
                }
                case 2: {
                    orientation = 180;
                    value = "portraitReverse";
                    break;
                }
                case 3: {
                    orientation = -90;
                    value = "landscapeReverse";
                }
            }
            WXUtils.getCache().evictAll();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("value", value);
            params.put("orientation", orientation);
            this.mWXSDKInstance.fireGlobalEventCallback("orientationchange", params);
        }
    }

    private void updateInitDeviceParams(Context context) {
        WXParams params = WXBridgeManager.getInstance().getInitParams();
        if (params != null && !TextUtils.equals((CharSequence)params.getDeviceWidth(), (CharSequence)String.valueOf(WXViewUtils.getScreenWidth(context)))) {
            params.setDeviceWidth(String.valueOf(WXViewUtils.getScreenWidth(context)));
            params.setDeviceHeight(String.valueOf(WXViewUtils.getScreenHeight(context)));
            float density = WXEnvironment.sApplication.getResources().getDisplayMetrics().density;
            WXEnvironment.addCustomOptions("scale", Float.toString(density));
            String statusBarHeight = null;
            if (WXViewUtils.getStatusBarHeight(context) > 0) {
                statusBarHeight = String.valueOf(WXViewUtils.getStatusBarHeight(context));
            }
            WXBridgeManager.getInstance().updateInitDeviceParams(params.getDeviceWidth(), params.getDeviceHeight(), Float.toString(density), statusBarHeight);
            WXBridgeManager.getInstance().setDeviceDisplay(this.mWXSDKInstance.getInstanceId(), WXViewUtils.getScreenWidth(context), WXViewUtils.getScreenHeight(context), WXViewUtils.getScreenDensity(context));
        }
    }

    @Override
    public synchronized boolean fireGlobalEvent(String key, Map<String, Object> params) {
        if (this.isReady) {
            return super.fireGlobalEvent(key, params);
        }
        this.mFireCaches.add(new FireEvent(key, params));
        return true;
    }

    @Override
    public void onJsFrameworkReady() {
        this.runDelayedRenderCaches(this.mRenderCaches);
        if (this.mWXSDKInstance != null) {
            this.initViewPortWidth(true);
            this.initFlexDirection();
        }
    }

    public void runDelayedRenderCaches(List<Message> list) {
        if (list.size() > 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                this.mHandler.sendMessage(list.get(i));
            }
            list.clear();
        }
    }

    private void initViewPortWidth(boolean fromMetaModule) {
        if (this.isCompilerWithUniapp) {
            if (this.mWXSDKInstance == null) {
                return;
            }
            int screenWidth = this.mWebview.obtainApp().getInt(0);
            if (fromMetaModule) {
                screenWidth = WXViewUtils.getScreenWidth(this.getContext());
            }
            this.mViewPort = (float)screenWidth / this.mWebview.getScale();
            this.mWXSDKInstance.setInstanceViewPortWidth(this.mViewPort, fromMetaModule);
        }
    }

    private void initFlexDirection() {
        if (this.mNvueCfgData != null && this.mNvueCfgData.has("flex-direction")) {
            String def = this.mNvueCfgData.optString("flex-direction");
            WXBridgeManager.getInstance().setFlexDirectionDef(def);
        }
    }

    @Override
    public void recoveryInstance() {
        if (this.mWXSDKView != null) {
            View v;
            if (!this.isChlid && (v = this.mWebview.getActivity().getCurrentFocus()) != null) {
                DeviceInfo.hideIME((View)v);
            }
            this.mWXSDKView.clearFocus();
            this.clearFocus();
            this.removeView(this.mWXSDKView);
            this.mWXSDKView = null;
            this.isPre = false;
        }
        super.recoveryInstance();
        this.isFrameShow = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mWebview != null && this.mWebview instanceof AdaUniWebView) {
            try {
                ((AdaUniWebView)this.mWebview).updateScreenAndDisplay();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateDeviceDisplay(float defaultWidth, float defaultHeight, boolean isWidthWrapContent, boolean isHeightWrapContent) {
        if (this.mWXSDKInstance != null && this.mWebview != null && this.mWebview.getActivity() != null) {
            int sScreenAllHeight = this.mWebview.obtainApp().getInt(2);
            int sScreenWidth = this.mWebview.obtainApp().getInt(0);
            int sScreenHeight = this.mWebview.obtainApp().getInt(1);
            if (!this.mWXSDKInstance.isOnSizeChangedRender()) {
                return;
            }
            if (!this.mWXSDKInstance.isOnSizeChangedRender()) {
                return;
            }
            HashMap<String, Number> screen = new HashMap<String, Number>();
            float scale = this.mWebview.getScale();
            screen.put("resolutionHeight", (int)((float)sScreenAllHeight / scale));
            screen.put("resolutionWidth", (int)((float)sScreenWidth / scale));
            screen.put("dpiX", Float.valueOf(DeviceInfo.dpiX));
            screen.put("dpiY", Float.valueOf(DeviceInfo.dpiY));
            HashMap<String, Integer> display = new HashMap<String, Integer>();
            display.put("resolutionHeight", (int)((float)sScreenHeight / scale));
            display.put("resolutionWidth", (int)((float)sScreenWidth / scale));
            StringBuilder buffer = new StringBuilder();
            for (String key : screen.keySet()) {
                buffer.append("plus.screen.").append(key).append("=").append(screen.get(key)).append(";");
            }
            for (String key : display.keySet()) {
                buffer.append("plus.display.").append(key).append("=").append(display.get(key)).append(";");
            }
            this.mWebview.evalJS(buffer.toString());
            if (this.isCompilerWithUniapp) {
                float viewPort = (float)sScreenWidth / this.mWebview.getScale();
                this.mWXSDKInstance.setInstanceViewPortWidth(viewPort, true);
            }
            if (!this.isService) {
                this.mWXSDKInstance.setDeviceDisplayOfPage(sScreenWidth, sScreenHeight);
                this.mWXSDKInstance.reloadPageLayout();
                WXBridgeManager.getInstance().setDefaultRootSize(this.mWXSDKInstance.getInstanceId(), defaultWidth, defaultHeight, isWidthWrapContent, isHeightWrapContent);
            }
        }
    }

    class FireEvent {
        String key;
        Map<String, Object> params;

        public FireEvent(String key, Map<String, Object> params) {
            this.key = key;
            this.params = params;
        }
    }
}

