/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.daya.orchestra.accompany.common.Constants;
import com.daya.orchestra.accompany.receiver.HeadsetPlugListener;
import com.daya.orchestra.accompany.utils.ALOG;

public class HeadsetPlugReceiver
extends BroadcastReceiver {
    private HeadsetPlugListener mHeadsetPlugListener;

    public HeadsetPlugReceiver(HeadsetPlugListener headsetPlugListener) {
        this.mHeadsetPlugListener = headsetPlugListener;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        ALOG.i("HeadsetPlugReceiver onReceive");
        if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(action)) {
            if (Build.VERSION.SDK_INT >= 14) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                ALOG.i("HeadsetPlugReceiver onReceive state:" + state);
                if (2 == state) {
                    this.mHeadsetPlugListener.onHeadsetPlug(true, "\u84dd\u7259\u8033\u673a");
                }
                if (0 == state) {
                    this.mHeadsetPlugListener.onHeadsetPlug(false, "\u84dd\u7259\u8033\u673a");
                }
            }
        } else if ("android.intent.action.HEADSET_PLUG".equals(action) && intent.hasExtra("state")) {
            if (intent.getIntExtra("state", 0) == 0) {
                Constants.HEADSET_PLUE_TAG = "";
                this.mHeadsetPlugListener.onHeadsetPlug(false, "\u6709\u7ebf\u8033\u673a");
            } else if (intent.getIntExtra("state", 0) == 1) {
                Constants.HEADSET_PLUE_TAG = "\u6709\u7ebf\u8033\u673a";
                this.mHeadsetPlugListener.onHeadsetPlug(true, "\u6709\u7ebf\u8033\u673a");
            }
        }
    }
}

