/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.service;

import android.app.Service;
import android.content.Intent;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import com.daya.orchestra.accompany.service.MusicPlayContract;
import java.io.IOException;

public class MusicService
extends Service {
    MusicPlayContract contract;
    public String path = "";
    private MediaPlayer mMediaPlayer;
    private PlaybackParams playParam;

    public IBinder onBind(Intent intent) {
        return new MyBinder();
    }

    public void onCreate() {
        super.onCreate();
        Log.e((String)"\u670d\u52a1", (String)"\u51c6\u5907\u64ad\u653e\u97f3\u4e50");
    }

    public class MyBinder
    extends Binder {
        public boolean isPlaying() {
            return null == MusicService.this.mMediaPlayer ? false : MusicService.this.mMediaPlayer.isPlaying();
        }

        public void setPlayParam(PlaybackParams param) {
            MusicService.this.playParam = param;
        }

        public void onPlay(boolean isPlaying, String musicPath) {
            if (MusicService.this.path.equals(musicPath)) {
                if (!isPlaying) {
                    if (MusicService.this.mMediaPlayer == null) {
                        this.startPlaying(musicPath);
                    } else {
                        this.resumePlaying();
                    }
                } else {
                    this.pausePlaying();
                }
            } else {
                this.startPlaying(musicPath);
            }
        }

        public void startPlaying(String musicPath) {
            MusicService.this.path = musicPath;
            try {
                if (MusicService.this.mMediaPlayer == null) {
                    MusicService.this.mMediaPlayer = new MediaPlayer();
                    MusicService.this.mMediaPlayer.setOnPreparedListener(mp -> {
                        mp.start();
                        if (MusicService.this.contract != null) {
                            MusicService.this.contract.setOnPreparedListener();
                            MusicService.this.contract.onPlay(true);
                        }
                    });
                    MusicService.this.mMediaPlayer.setOnErrorListener((mediaPlayer, i, i1) -> {
                        if (MusicService.this.contract != null) {
                            MusicService.this.contract.setOnErrorListener();
                            MusicService.this.contract.onPlay(false);
                        }
                        return false;
                    });
                    MusicService.this.mMediaPlayer.setOnCompletionListener(mediaPlayer -> {
                        if (MusicService.this.contract != null) {
                            MusicService.this.contract.setOnCompletionListener();
                            MusicService.this.contract.onPlay(false);
                        }
                    });
                }
                MusicService.this.mMediaPlayer.reset();
                MusicService.this.mMediaPlayer.setDataSource(musicPath);
                if (Build.VERSION.SDK_INT >= 23 && MusicService.this.playParam != null) {
                    try {
                        if (MusicService.this.mMediaPlayer != null) {
                            MusicService.this.mMediaPlayer.setPlaybackParams(MusicService.this.playParam);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                MusicService.this.mMediaPlayer.prepare();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void resumePlaying() {
            if (MusicService.this.mMediaPlayer != null) {
                MusicService.this.mMediaPlayer.start();
                if (MusicService.this.contract != null) {
                    MusicService.this.contract.setOnPreparedListener();
                    MusicService.this.contract.onPlay(true);
                }
            }
        }

        public void stopPlaying() {
            if (MusicService.this.mMediaPlayer == null) {
                return;
            }
            MusicService.this.mMediaPlayer.stop();
            MusicService.this.mMediaPlayer.reset();
            MusicService.this.mMediaPlayer.release();
            MusicService.this.mMediaPlayer = null;
            if (MusicService.this.contract != null) {
                MusicService.this.contract.setOnCompletionListener();
                MusicService.this.contract.onPlay(false);
            }
        }

        public void pausePlaying() {
            if (null != MusicService.this.mMediaPlayer) {
                MusicService.this.mMediaPlayer.pause();
                if (null != MusicService.this.contract) {
                    MusicService.this.contract.setOnPauseListener();
                    MusicService.this.contract.onPlay(false);
                }
            }
        }

        public int getDuration() {
            return null == MusicService.this.mMediaPlayer ? 0 : MusicService.this.mMediaPlayer.getDuration();
        }

        public int getCurrenPostion() {
            return null == MusicService.this.mMediaPlayer ? 0 : MusicService.this.mMediaPlayer.getCurrentPosition();
        }

        public void seekTo(int mesc) {
            if (MusicService.this.mMediaPlayer != null) {
                MusicService.this.mMediaPlayer.seekTo(mesc);
            }
        }

        public void setCallback(MusicPlayContract callback) {
            MusicService.this.contract = callback;
        }
    }
}

