/*
 * Decompiled with CFR 0.152.
 */
package com.daya.orchestra.accompany.utils;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.daya.orchestra.accompany.R;
import com.daya.orchestra.accompany.utils.SizeUtils;
import com.daya.orchestra.accompany.utils.Utils;

public class ToastUtil {
    public static volatile ToastUtil instance;
    private Toast toast;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ToastUtil getInstance() {
        if (null != instance) return instance;
        Class<ToastUtil> clazz = ToastUtil.class;
        synchronized (ToastUtil.class) {
            if (null != instance) return instance;
            instance = new ToastUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void show(Context context, String toastStr) {
        this.showShort(toastStr);
    }

    public void showShort(String toastStr) {
        if (this.init(toastStr, 0) == null) {
            this.toast = new Toast((Context)Utils.getApp());
            this.toast.setText((CharSequence)toastStr);
            this.toast.setDuration(0);
            this.toast.show();
        }
    }

    private Toast init(String message, int duration) {
        try {
            if (this.toast != null) {
                TextView text = (TextView)this.toast.getView();
                if (text != null) {
                    text.setText((CharSequence)message);
                }
            } else {
                int dp26 = SizeUtils.dp2px(26.0f);
                int dp10 = SizeUtils.dp2px(10.0f);
                TextView contentView = new TextView((Context)Utils.getApp());
                contentView.setGravity(17);
                contentView.setBackgroundResource(R.drawable.shape_toast);
                contentView.setTextSize(15.0f);
                contentView.setTextColor(Utils.getApp().getResources().getColor(R.color.white));
                contentView.setPadding(dp26, dp10, dp26, dp10);
                contentView.setText((CharSequence)message);
                this.toast = new Toast((Context)Utils.getApp());
                this.toast.setGravity(17, 0, 0);
                this.toast.setView((View)contentView);
            }
            this.toast.setDuration(duration);
            this.toast.show();
        }
        catch (Exception e) {
            Toast.makeText((Context)Utils.getApp(), (CharSequence)message, (int)duration).show();
            e.printStackTrace();
        }
        return this.toast;
    }
}

