/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.graphics;

import com.timevale.seal.graphics.GraphicsStamp;
import com.timevale.seal.graphics.impl.o;
import esign.utils.exception.ag;
import esign.utils.exception.aj;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GraphicsTool {
    INSTANCE;

    private static final int[] PALETTE;
    private static final Logger LOGGER;
    public static final IndexColorModel CM_SEAL;

    public void createTextTemplate(o template, String file) throws IOException, aj {
        FileOutputStream f2 = new FileOutputStream(file);
        byte[] buff = this.createTextTemplate(template).getData();
        f2.write(buff);
        f2.close();
    }

    public GraphicsStamp createTextTemplate(o template) throws aj {
        BufferedImage tmp = new BufferedImage(100, 100, 2);
        Graphics2D gtmp = tmp.createGraphics();
        template.a(gtmp);
        BufferedImage image = new BufferedImage(template.c(), template.d(), 2);
        Graphics2D g2 = image.createGraphics();
        template.a(g2, 0, 0, true, true);
        gtmp.dispose();
        g2.dispose();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", output);
        }
        catch (IOException e2) {
            LOGGER.error("write image to buffer failed.", (Throwable)e2);
            throw ag.ag.a(e2);
        }
        return new GraphicsStamp(output.toByteArray(), template.c(), template.d());
    }

    public IndexColorModel createColorModel(int[] palette, int transIndex) {
        IndexColorModel icm = new IndexColorModel(3, palette.length, palette, 0, -1 != transIndex, transIndex, 0);
        return icm;
    }

    static {
        PALETTE = new int[]{0xFFFFFF, Color.RED.getRGB(), Color.BLUE.getRGB(), Color.BLACK.getRGB()};
        LOGGER = LoggerFactory.getLogger(GraphicsTool.class);
        CM_SEAL = INSTANCE.createColorModel(PALETTE, 0);
    }
}

