/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.dstu;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.dstu.SignatureSpi;
import java.io.IOException;
import java.security.SignatureException;

public class SignatureSpiLe
extends SignatureSpi {
    void reverseBytes(byte[] bytes) {
        for (int i2 = 0; i2 < bytes.length / 2; ++i2) {
            byte tmp = bytes[i2];
            bytes[i2] = bytes[bytes.length - 1 - i2];
            bytes[bytes.length - 1 - i2] = tmp;
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] signature = ASN1OctetString.getInstance(super.engineSign()).getOctets();
        this.reverseBytes(signature);
        try {
            return new DEROctetString(signature).getEncoded();
        }
        catch (Exception e2) {
            throw new SignatureException(e2.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] bytes;
        try {
            bytes = ((ASN1OctetString)ASN1OctetString.fromByteArray(sigBytes)).getOctets();
        }
        catch (IOException iOException) {
            throw new SignatureException("error decoding signature bytes.");
        }
        this.reverseBytes(bytes);
        try {
            return super.engineVerify(new DEROctetString(bytes).getEncoded());
        }
        catch (SignatureException signatureException) {
            SignatureException e2 = signatureException;
            throw signatureException;
        }
        catch (Exception e3) {
            throw new SignatureException(e3.toString());
        }
    }
}

