/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.bean;

import com.timevale.esign.sdk.tech.impl.checker.IParametersValidator;
import com.timevale.tech.sdk.utils.d;
import esign.utils.s;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SignPDFDocBean
implements IParametersValidator {
    private static final String STREAM = "stream";
    private String srcFile;
    private String dstFile;
    private byte[] stream;
    private String fileName;
    private String ownerPassword;
    private boolean isStreamMode = false;
    private boolean isSimple = false;
    private boolean showImage;
    private byte[] image;
    private float imageShowWidth = 60.0f;
    private float imageShowHeight = 60.0f;

    public SignPDFDocBean(String srcFile, String dstFile, String fileName) {
        this(srcFile, dstFile, fileName, "");
    }

    public SignPDFDocBean(String srcFile, String dstFile, String fileName, String ownerPassword) {
        this.srcFile = srcFile;
        this.dstFile = dstFile;
        this.fileName = fileName;
        this.ownerPassword = ownerPassword == null ? "" : ownerPassword;
        this.stream = null;
    }

    public SignPDFDocBean(byte[] stream, String fileName) {
        this(stream, fileName, "");
    }

    public SignPDFDocBean(byte[] stream, String fileName, String ownerPassword) {
        this(stream, fileName, ownerPassword, null);
    }

    public SignPDFDocBean(byte[] stream, String fileName, String ownerPassword, String dstFile) {
        this.stream = stream;
        this.fileName = fileName;
        this.ownerPassword = ownerPassword == null ? "" : ownerPassword;
        this.dstFile = dstFile;
        this.isStreamMode = true;
        this.srcFile = STREAM;
    }

    public String getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(String srcFile) {
        this.srcFile = srcFile;
    }

    public String getDstFile() {
        return this.dstFile;
    }

    public byte[] getStream() {
        return this.stream;
    }

    public void setStream(byte[] stream) {
        this.stream = stream;
    }

    public String getFileName() {
        return this.getRealName();
    }

    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    public boolean isStreamMode() {
        return this.isStreamMode;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public boolean isShowImage() {
        return this.showImage;
    }

    public void setShowImage(boolean showImage) {
        this.showImage = showImage;
    }

    public byte[] getImage() {
        if (this.image == null) {
            try {
                this.image = this.getLogoImage();
            }
            catch (IOException iOException) {}
        }
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public float getImageShowWidth() {
        return this.imageShowWidth;
    }

    public void setImageShowWidth(float imageShowWidth) {
        this.imageShowWidth = imageShowWidth;
    }

    public float getImageShowHeight() {
        return this.imageShowHeight;
    }

    public void setImageShowHeight(float imageShowHeight) {
        this.imageShowHeight = imageShowHeight;
    }

    public String getRealName() {
        if (!s.a((String)this.fileName)) {
            return this.fileName;
        }
        if (this.isStreamMode()) {
            return STREAM;
        }
        File file = new File(this.srcFile);
        return file.getName();
    }

    @Override
    public int validator() {
        if (this.isStreamMode) {
            if (this.stream == null || this.stream.length <= 0) {
                return 9007;
            }
        } else if (s.a((String)this.srcFile)) {
            return 2005;
        }
        return 0;
    }

    private byte[] getLogoImage() throws IOException {
        return d.b(ImageIO.read(SignPDFDocBean.class.getResource("/images/logo.png")), "png");
    }
}

