/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.config.support;

import com.yeepay.g3.sdk.yop.YopServiceException;
import com.yeepay.g3.sdk.yop.config.CertConfig;
import com.yeepay.g3.sdk.yop.utils.RSAKeyUtils;
import com.yeepay.shade.org.apache.commons.lang3.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtils.class);

    public static PublicKey loadPublicKey(CertConfig certConfig) {
        PublicKey publicKey;
        if (null == certConfig.getStoreType()) {
            throw new YopServiceException("Can't init YOP public key! Store type is error.");
        }
        switch (certConfig.getStoreType()) {
            case STRING: {
                try {
                    publicKey = RSAKeyUtils.string2PublicKey(certConfig.getValue());
                    break;
                }
                catch (Exception ex) {
                    throw new YopServiceException(ex, "Failed to load public key form config file is error," + certConfig);
                }
            }
            default: {
                throw new RuntimeException("Not support cert store type.");
            }
        }
        return publicKey;
    }

    public static PrivateKey loadPrivateKey(CertConfig certConfig) {
        PrivateKey privateKey = null;
        if (null == certConfig.getStoreType()) {
            throw new YopServiceException("Can't init ISV private key! Store type is error.");
        }
        switch (certConfig.getStoreType()) {
            case STRING: {
                try {
                    privateKey = RSAKeyUtils.string2PrivateKey(certConfig.getValue());
                    break;
                }
                catch (Exception ex) {
                    throw new YopServiceException(ex, "Failed to load private key form config file is error, " + certConfig);
                }
            }
            case FILE_P12: {
                try {
                    char[] password = certConfig.getPassword().toCharArray();
                    KeyStore keystore = KeyStore.getInstance("PKCS12");
                    keystore.load(ConfigUtils.getInputStream(certConfig.getValue()), password);
                    Enumeration<String> aliases = keystore.aliases();
                    String keyAlias = "";
                    while (aliases.hasMoreElements()) {
                        keyAlias = aliases.nextElement();
                    }
                    privateKey = (PrivateKey)keystore.getKey(keyAlias, password);
                    break;
                }
                catch (Exception ex) {
                    throw new YopServiceException(ex, "Cert key is error, " + certConfig);
                }
            }
            default: {
                throw new RuntimeException("Not support cert store type.");
            }
        }
        return privateKey;
    }

    public static List<String> listFiles(String dir) throws IOException, URISyntaxException {
        URL url;
        URL uRL = url = StringUtils.startsWith(dir, "file://") ? new URL(dir) : ConfigUtils.getResource(dir);
        if (url == null) {
            return Collections.emptyList();
        }
        if (StringUtils.equals(url.getProtocol(), "file")) {
            File file = new File(url.toURI());
            if (file.isDirectory()) {
                String resource;
                ArrayList<String> files = new ArrayList<String>();
                InputStream in = url.openStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((resource = br.readLine()) != null) {
                    files.add(dir + File.separator + resource);
                }
                return files;
            }
            throw new IllegalArgumentException(dir + " is not a dir.");
        }
        LOGGER.info("can't read dir from protocol:" + url.getProtocol());
        return Collections.emptyList();
    }

    public static InputStream getInputStream(String location) throws FileNotFoundException {
        InputStream fis = StringUtils.startsWith(location, "file://") ? new FileInputStream(StringUtils.substring(location, 6)) : ConfigUtils.getResourceAsStream(location);
        if (null == fis) {
            throw new FileNotFoundException(location);
        }
        return fis;
    }

    public static URL getResource(String resource) {
        URL url;
        if (StringUtils.startsWith(resource, "/")) {
            resource = StringUtils.substring(resource, 1);
        }
        return (url = ConfigUtils.getContextClassLoader().getResource(resource)) == null ? ConfigUtils.class.getResource("/" + resource) : url;
    }

    public static InputStream getResourceAsStream(String resource) {
        InputStream in;
        if (StringUtils.startsWith(resource, "/")) {
            resource = StringUtils.substring(resource, 1);
        }
        return (in = ConfigUtils.getContextClassLoader().getResourceAsStream(resource)) == null ? ConfigUtils.class.getResourceAsStream("/" + resource) : in;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

