/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.eac;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.timevale.tgtext.bouncycastle.asn1.eac.UnsignedInteger;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPublicKey
extends PublicKeyDataObject {
    private ASN1ObjectIdentifier usage;
    private BigInteger modulus;
    private BigInteger exponent;
    private int valid = 0;
    private static int modulusValid = 1;
    private static int exponentValid = 2;

    RSAPublicKey(ASN1Sequence seq) {
        Enumeration en2 = seq.getObjects();
        this.usage = ASN1ObjectIdentifier.getInstance(en2.nextElement());
        block4: while (en2.hasMoreElements()) {
            UnsignedInteger val = UnsignedInteger.getInstance(en2.nextElement());
            switch (val.getTagNo()) {
                case 1: {
                    this.setModulus(val);
                    continue block4;
                }
                case 2: {
                    this.setExponent(val);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown DERTaggedObject :" + val.getTagNo() + "-> not an Iso7816RSAPublicKeyStructure");
        }
        if (this.valid != 3) {
            throw new IllegalArgumentException("missing argument -> not an Iso7816RSAPublicKeyStructure");
        }
    }

    public RSAPublicKey(ASN1ObjectIdentifier usage, BigInteger modulus, BigInteger exponent) {
        this.usage = usage;
        this.modulus = modulus;
        this.exponent = exponent;
    }

    @Override
    public ASN1ObjectIdentifier getUsage() {
        return this.usage;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    private void setModulus(UnsignedInteger modulus) {
        if ((this.valid & modulusValid) == 0) {
            this.valid |= modulusValid;
            this.modulus = modulus.getValue();
            return;
        }
        throw new IllegalArgumentException("Modulus already set");
    }

    private void setExponent(UnsignedInteger exponent) {
        if ((this.valid & exponentValid) == 0) {
            this.valid |= exponentValid;
            this.exponent = exponent.getValue();
            return;
        }
        throw new IllegalArgumentException("Exponent already set");
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.usage);
        v2.add(new UnsignedInteger(1, this.getModulus()));
        v2.add(new UnsignedInteger(2, this.getPublicExponent()));
        return new DERSequence(v2);
    }
}

