/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.operator.InputExpander;
import com.timevale.tgtext.bouncycastle.operator.InputExpanderProvider;
import com.timevale.tgtext.bouncycastle.util.io.StreamOverflowException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class ZlibExpanderProvider
implements InputExpanderProvider {
    private final long limit;

    public ZlibExpanderProvider() {
        this.limit = -1L;
    }

    public ZlibExpanderProvider(long limit) {
        this.limit = limit;
    }

    @Override
    public InputExpander get(final AlgorithmIdentifier algorithm) {
        return new InputExpander(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithm;
            }

            @Override
            public InputStream getInputStream(InputStream comIn) {
                FilterInputStream s2 = new InflaterInputStream(comIn);
                if (ZlibExpanderProvider.this.limit >= 0L) {
                    s2 = new a(s2, ZlibExpanderProvider.this.limit);
                }
                return s2;
            }
        };
    }

    private static class a
    extends FilterInputStream {
        private long a;

        public a(InputStream input, long limit) {
            super(input);
            this.a = limit;
        }

        @Override
        public int read() throws IOException {
            int b2;
            if (this.a >= 0L && ((b2 = this.in.read()) < 0 || --this.a >= 0L)) {
                return b2;
            }
            throw new StreamOverflowException("expanded byte limit exceeded");
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (len <= 0) {
                return super.read(buf, off, len);
            }
            if (this.a < 1L) {
                this.read();
                return -1;
            }
            int actualLen = this.a > (long)len ? len : (int)this.a;
            int numRead = this.in.read(buf, off, actualLen);
            if (numRead > 0) {
                this.a -= (long)numRead;
            }
            return numRead;
        }
    }
}

