/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.unmarshaller;

import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.shade.com.fasterxml.jackson.annotation.JsonInclude;
import com.yeepay.shade.com.fasterxml.jackson.core.JsonProcessingException;
import com.yeepay.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import com.yeepay.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.yeepay.shade.com.fasterxml.jackson.databind.SerializationFeature;
import com.yeepay.shade.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;

public class JacksonJsonMarshaller {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private JacksonJsonMarshaller() {
    }

    public static <T> T unmarshal(String content, Class<T> objectType) {
        try {
            return objectMapper.readValue(content, objectType);
        }
        catch (IOException e) {
            throw new YopClientException(e.getMessage(), e);
        }
    }

    public static <T> T unmarshal(InputStream content, Class<T> objectType) {
        try {
            return objectMapper.readValue(content, objectType);
        }
        catch (IOException e) {
            throw new YopClientException(e.getMessage(), e);
        }
    }

    public static void load(String content, Object obj) {
        try {
            objectMapper.readerForUpdating(obj).readValue(content);
        }
        catch (IOException ex) {
            throw new YopClientException(ex.getMessage(), ex);
        }
    }

    public static String marshal(Object content) {
        try {
            return objectMapper.writeValueAsString(content);
        }
        catch (JsonProcessingException e) {
            throw new YopClientException(e.getMessage(), e);
        }
    }

    static {
        objectMapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.setAnnotationIntrospector(new JacksonAnnotationIntrospector());
    }
}

