/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.OCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponseBytes;
import com.timevale.tgtext.bouncycastle.ocsp.BasicOCSPResp;
import com.timevale.tgtext.bouncycastle.ocsp.OCSPException;
import java.io.IOException;
import java.io.InputStream;

public class OCSPResp {
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse resp) {
        this.resp = resp;
    }

    public OCSPResp(byte[] resp) throws IOException {
        this(new ASN1InputStream(resp));
    }

    public OCSPResp(InputStream in) throws IOException {
        this(new ASN1InputStream(in));
    }

    private OCSPResp(ASN1InputStream aIn) throws IOException {
        try {
            this.resp = OCSPResponse.getInstance(aIn.readObject());
            return;
        }
        catch (IllegalArgumentException e2) {
            throw new IOException("malformed response: " + e2.getMessage());
        }
        catch (ClassCastException e3) {
            throw new IOException("malformed response: " + e3.getMessage());
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes rb = this.resp.getResponseBytes();
        if (rb == null) {
            return null;
        }
        if (rb.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1Primitive obj = ASN1Primitive.fromByteArray(rb.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(obj));
            }
            catch (Exception e2) {
                throw new OCSPException("problem decoding object: " + e2, e2);
            }
        }
        return rb.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OCSPResp)) {
            return false;
        }
        OCSPResp r2 = (OCSPResp)o2;
        return this.resp.equals(r2.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

