/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.jcajce.b;
import com.timevale.tgtext.bouncycastle.cms.jcajce.c;
import com.timevale.tgtext.bouncycastle.cms.jcajce.d;
import com.timevale.tgtext.bouncycastle.cms.jcajce.e;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JceGenericKey;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JceCMSContentEncryptorBuilder {
    private static Map keySizes = new HashMap<ASN1ObjectIdentifier, Integer>();
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private c helper = new c(new b());
    private SecureRandom random;

    private static int getKeySize(ASN1ObjectIdentifier oid) {
        Integer size = (Integer)keySizes.get(oid);
        if (size != null) {
            return size;
        }
        return -1;
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, JceCMSContentEncryptorBuilder.getKeySize(encryptionOID));
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public JceCMSContentEncryptorBuilder setProvider(Provider provider) {
        this.helper = new c(new e(provider));
        return this;
    }

    public JceCMSContentEncryptorBuilder setProvider(String providerName) {
        this.helper = new c(new d(providerName));
        return this;
    }

    public JceCMSContentEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        return new a(this.encryptionOID, this.keySize, this.random);
    }

    static {
        keySizes.put(CMSAlgorithm.AES128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.AES192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.AES256_CBC, Integers.valueOf(256));
        keySizes.put(CMSAlgorithm.CAMELLIA128_CBC, Integers.valueOf(128));
        keySizes.put(CMSAlgorithm.CAMELLIA192_CBC, Integers.valueOf(192));
        keySizes.put(CMSAlgorithm.CAMELLIA256_CBC, Integers.valueOf(256));
    }

    private class a
    implements OutputEncryptor {
        private SecretKey b;
        private AlgorithmIdentifier c;
        private Cipher d;

        a(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
            KeyGenerator keyGen = JceCMSContentEncryptorBuilder.this.helper.i(encryptionOID);
            if (random == null) {
                random = new SecureRandom();
            }
            if (keySize < 0) {
                keyGen.init(random);
            } else {
                keyGen.init(keySize, random);
            }
            this.d = JceCMSContentEncryptorBuilder.this.helper.b(encryptionOID);
            this.b = keyGen.generateKey();
            AlgorithmParameters params = JceCMSContentEncryptorBuilder.this.helper.a(encryptionOID, this.b, random);
            try {
                this.d.init(1, (Key)this.b, params, random);
            }
            catch (GeneralSecurityException e2) {
                throw new CMSException("unable to initialize cipher: " + e2.getMessage(), e2);
            }
            if (params == null) {
                params = this.d.getParameters();
            }
            this.c = JceCMSContentEncryptorBuilder.this.helper.a(encryptionOID, params);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream(OutputStream dOut) {
            return new CipherOutputStream(dOut, this.d);
        }

        @Override
        public GenericKey getKey() {
            return new JceGenericKey(this.c, this.b);
        }
    }
}

