/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls;

import cfca.sadk.org.bouncycastle.crypto.tls.DTLSRecordLayer;
import cfca.sadk.org.bouncycastle.crypto.tls.DatagramTransport;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class DTLSTransport
implements DatagramTransport {
    private final DTLSRecordLayer recordLayer;

    DTLSTransport(DTLSRecordLayer recordLayer) {
        this.recordLayer = recordLayer;
    }

    public int getReceiveLimit() throws IOException {
        return this.recordLayer.getReceiveLimit();
    }

    public int getSendLimit() throws IOException {
        return this.recordLayer.getSendLimit();
    }

    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        try {
            return this.recordLayer.receive(buf, off, len, waitMillis);
        }
        catch (TlsFatalAlert fatalAlert) {
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80);
        }
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        try {
            this.recordLayer.send(buf, off, len);
        }
        catch (TlsFatalAlert fatalAlert) {
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80);
        }
    }

    public void close() throws IOException {
        this.recordLayer.close();
    }
}

