/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cert.ocsp;

import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ocsp.ResponseData;
import cfca.sadk.org.bouncycastle.asn1.ocsp.SingleResponse;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.cert.ocsp.OCSPUtils;
import cfca.sadk.org.bouncycastle.cert.ocsp.RespID;
import cfca.sadk.org.bouncycastle.cert.ocsp.SingleResp;
import java.util.Date;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        for (int i = 0; i != rs.length; ++i) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
        }
        return rs;
    }

    public Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

