/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class StreamUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static void io(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int amount;
        if (bufferSize == -1) {
            bufferSize = 8192;
        }
        byte[] buffer = new byte[bufferSize];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    public static void io(Reader in, Writer out) throws IOException {
        StreamUtil.io(in, out, -1);
    }

    public static void io(Reader in, Writer out, int bufferSize) throws IOException {
        int amount;
        if (bufferSize == -1) {
            bufferSize = 4096;
        }
        char[] buffer = new char[bufferSize];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    public static String readText(InputStream in) throws IOException {
        return StreamUtil.readText(in, null, -1);
    }

    public static String readText(InputStream in, String encoding) throws IOException {
        return StreamUtil.readText(in, encoding, -1);
    }

    public static String readText(InputStream in, String encoding, int bufferSize) throws IOException {
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        return StreamUtil.readText(reader, bufferSize);
    }

    public static String readText(Reader reader, int bufferSize) throws IOException {
        StringWriter writer = new StringWriter();
        StreamUtil.io(reader, writer, bufferSize);
        return writer.toString();
    }
}

