/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils;

import com.yeepay.shade.org.apache.commons.lang3.Validate;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    private RandomUtils() {
    }

    public static Random threadLocalRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom secureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    }

    public static int nextInt() {
        return RandomUtils.nextInt(ThreadLocalRandom.current());
    }

    public static int nextInt(Random random) {
        int n = random.nextInt();
        n = n == Integer.MIN_VALUE ? 0 : Math.abs(n);
        return n;
    }

    public static int nextInt(int max) {
        return RandomUtils.nextInt(ThreadLocalRandom.current(), max);
    }

    public static int nextInt(Random random, int max) {
        return random.nextInt(max);
    }

    public static int nextInt(int min, int max) {
        return RandomUtils.nextInt(ThreadLocalRandom.current(), min, max);
    }

    public static int nextInt(Random random, int min, int max) {
        Validate.isTrue(max >= min, "Start value must be smaller or equal to end value.", new Object[0]);
        if (min < 0) {
            min = 0;
        }
        if (min == max) {
            return min;
        }
        return min + random.nextInt(max - min);
    }
}

