/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util;

import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.GF2Field;

public class ComputeInField {
    private short[][] A;
    short[] x;

    public short[] solveEquation(short[][] B, short[] b2) {
        try {
            int i2;
            if (B.length != b2.length) {
                throw new RuntimeException("The equation system is not solvable");
            }
            this.A = new short[B.length][B.length + 1];
            this.x = new short[B.length];
            for (i2 = 0; i2 < B.length; ++i2) {
                for (int j2 = 0; j2 < B[0].length; ++j2) {
                    this.A[i2][j2] = B[i2][j2];
                }
            }
            for (i2 = 0; i2 < b2.length; ++i2) {
                this.A[i2][b2.length] = GF2Field.addElem(b2[i2], this.A[i2][b2.length]);
            }
            this.computeZerosUnder(false);
            this.substitute();
            return this.x;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public short[][] inverse(short[][] coef) {
        try {
            int j2;
            int i2;
            this.A = new short[coef.length][2 * coef.length];
            if (coef.length != coef[0].length) {
                throw new RuntimeException("The matrix is not invertible. Please choose another one!");
            }
            for (i2 = 0; i2 < coef.length; ++i2) {
                for (j2 = 0; j2 < coef.length; ++j2) {
                    this.A[i2][j2] = coef[i2][j2];
                }
                for (j2 = coef.length; j2 < 2 * coef.length; ++j2) {
                    this.A[i2][j2] = 0;
                }
                this.A[i2][i2 + this.A.length] = 1;
            }
            this.computeZerosUnder(true);
            for (i2 = 0; i2 < this.A.length; ++i2) {
                short factor = GF2Field.invElem(this.A[i2][i2]);
                for (j2 = i2; j2 < 2 * this.A.length; ++j2) {
                    this.A[i2][j2] = GF2Field.multElem(this.A[i2][j2], factor);
                }
            }
            this.computeZerosAbove();
            short[][] inverse = new short[this.A.length][this.A.length];
            for (i2 = 0; i2 < this.A.length; ++i2) {
                for (j2 = this.A.length; j2 < 2 * this.A.length; ++j2) {
                    inverse[i2][j2 - this.A.length] = this.A[i2][j2];
                }
            }
            return inverse;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private void computeZerosUnder(boolean usedForInverse) throws RuntimeException {
        int length = usedForInverse ? 2 * this.A.length : this.A.length + 1;
        for (int k2 = 0; k2 < this.A.length - 1; ++k2) {
            for (int i2 = k2 + 1; i2 < this.A.length; ++i2) {
                short factor1 = this.A[i2][k2];
                short factor2 = GF2Field.invElem(this.A[k2][k2]);
                if (factor2 == 0) {
                    throw new RuntimeException("Matrix not invertible! We have to choose another one!");
                }
                for (int j2 = k2; j2 < length; ++j2) {
                    short tmp = GF2Field.multElem(this.A[k2][j2], factor2);
                    tmp = GF2Field.multElem(factor1, tmp);
                    this.A[i2][j2] = GF2Field.addElem(this.A[i2][j2], tmp);
                }
            }
        }
    }

    private void computeZerosAbove() throws RuntimeException {
        for (int k2 = this.A.length - 1; k2 > 0; --k2) {
            for (int i2 = k2 - 1; i2 >= 0; --i2) {
                short factor1 = this.A[i2][k2];
                short factor2 = GF2Field.invElem(this.A[k2][k2]);
                if (factor2 == 0) {
                    throw new RuntimeException("The matrix is not invertible");
                }
                for (int j2 = k2; j2 < 2 * this.A.length; ++j2) {
                    short tmp = GF2Field.multElem(this.A[k2][j2], factor2);
                    tmp = GF2Field.multElem(factor1, tmp);
                    this.A[i2][j2] = GF2Field.addElem(this.A[i2][j2], tmp);
                }
            }
        }
    }

    private void substitute() throws RuntimeException {
        short temp = GF2Field.invElem(this.A[this.A.length - 1][this.A.length - 1]);
        if (temp == 0) {
            throw new RuntimeException("The equation system is not solvable");
        }
        this.x[this.A.length - 1] = GF2Field.multElem(this.A[this.A.length - 1][this.A.length], temp);
        for (int i2 = this.A.length - 2; i2 >= 0; --i2) {
            short tmp = this.A[i2][this.A.length];
            for (int j2 = this.A.length - 1; j2 > i2; --j2) {
                temp = GF2Field.multElem(this.A[i2][j2], this.x[j2]);
                tmp = GF2Field.addElem(tmp, temp);
            }
            temp = GF2Field.invElem(this.A[i2][i2]);
            if (temp == 0) {
                throw new RuntimeException("Not solvable equation system");
            }
            this.x[i2] = GF2Field.multElem(tmp, temp);
        }
    }

    public short[][] multiplyMatrix(short[][] M1, short[][] M2) throws RuntimeException {
        if (M1[0].length != M2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        this.A = new short[M1.length][M2[0].length];
        for (int i2 = 0; i2 < M1.length; ++i2) {
            for (int j2 = 0; j2 < M2.length; ++j2) {
                for (int k2 = 0; k2 < M2[0].length; ++k2) {
                    short tmp = GF2Field.multElem(M1[i2][j2], M2[j2][k2]);
                    this.A[i2][k2] = GF2Field.addElem(this.A[i2][k2], tmp);
                }
            }
        }
        return this.A;
    }

    public short[] multiplyMatrix(short[][] M1, short[] m2) throws RuntimeException {
        if (M1[0].length != m2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[] B = new short[M1.length];
        for (int i2 = 0; i2 < M1.length; ++i2) {
            for (int j2 = 0; j2 < m2.length; ++j2) {
                short tmp = GF2Field.multElem(M1[i2][j2], m2[j2]);
                B[i2] = GF2Field.addElem(B[i2], tmp);
            }
        }
        return B;
    }

    public short[] addVect(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[] rslt = new short[vector1.length];
        for (int n2 = 0; n2 < rslt.length; ++n2) {
            rslt[n2] = GF2Field.addElem(vector1[n2], vector2[n2]);
        }
        return rslt;
    }

    public short[][] multVects(short[] vector1, short[] vector2) {
        if (vector1.length != vector2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] rslt = new short[vector1.length][vector2.length];
        for (int i2 = 0; i2 < vector1.length; ++i2) {
            for (int j2 = 0; j2 < vector2.length; ++j2) {
                rslt[i2][j2] = GF2Field.multElem(vector1[i2], vector2[j2]);
            }
        }
        return rslt;
    }

    public short[] multVect(short scalar, short[] vector) {
        short[] rslt = new short[vector.length];
        for (int n2 = 0; n2 < rslt.length; ++n2) {
            rslt[n2] = GF2Field.multElem(scalar, vector[n2]);
        }
        return rslt;
    }

    public short[][] multMatrix(short scalar, short[][] matrix) {
        short[][] rslt = new short[matrix.length][matrix[0].length];
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            for (int j2 = 0; j2 < matrix[0].length; ++j2) {
                rslt[i2][j2] = GF2Field.multElem(scalar, matrix[i2][j2]);
            }
        }
        return rslt;
    }

    public short[][] addSquareMatrix(short[][] matrix1, short[][] matrix2) {
        if (matrix1.length != matrix2.length || matrix1[0].length != matrix2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] rslt = new short[matrix1.length][matrix1.length];
        for (int i2 = 0; i2 < matrix1.length; ++i2) {
            for (int j2 = 0; j2 < matrix2.length; ++j2) {
                rslt[i2][j2] = GF2Field.addElem(matrix1[i2][j2], matrix2[i2][j2]);
            }
        }
        return rslt;
    }
}

