/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.x509.AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.x509.AttributeCertificateIssuer;
import com.timevale.tgtext.bouncycastle.x509.X509Attribute;
import com.timevale.tgtext.bouncycastle.x509.X509AttributeCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class X509V2AttributeCertificate
implements X509AttributeCertificate {
    private AttributeCertificate cert;
    private Date notBefore;
    private Date notAfter;

    private static AttributeCertificate getObject(InputStream in) throws IOException {
        try {
            return AttributeCertificate.getInstance(new ASN1InputStream(in).readObject());
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            throw iOException;
        }
        catch (Exception e3) {
            throw new IOException("exception decoding certificate structure: " + e3.toString());
        }
    }

    public X509V2AttributeCertificate(InputStream encIn) throws IOException {
        this(X509V2AttributeCertificate.getObject(encIn));
    }

    public X509V2AttributeCertificate(byte[] encoded) throws IOException {
        this(new ByteArrayInputStream(encoded));
    }

    X509V2AttributeCertificate(AttributeCertificate cert) throws IOException {
        this.cert = cert;
        try {
            this.notAfter = cert.getAcinfo().getAttrCertValidityPeriod().getNotAfterTime().getDate();
            this.notBefore = cert.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime().getDate();
            return;
        }
        catch (ParseException parseException) {
            throw new IOException("invalid data structure in certificate!");
        }
    }

    @Override
    public int getVersion() {
        return this.cert.getAcinfo().getVersion().getValue().intValue() + 1;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.cert.getAcinfo().getSerialNumber().getValue();
    }

    @Override
    public AttributeCertificateHolder getHolder() {
        return new AttributeCertificateHolder((ASN1Sequence)this.cert.getAcinfo().getHolder().toASN1Object());
    }

    @Override
    public AttributeCertificateIssuer getIssuer() {
        return new AttributeCertificateIssuer(this.cert.getAcinfo().getIssuer());
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public Date getNotAfter() {
        return this.notAfter;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        DERBitString id = this.cert.getAcinfo().getIssuerUniqueID();
        if (id != null) {
            byte[] bytes = id.getBytes();
            boolean[] boolId = new boolean[(bytes.length << 3) - id.getPadBits()];
            for (int i2 = 0; i2 != boolId.length; ++i2) {
                boolId[i2] = (bytes[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return boolId;
        }
        return null;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("certificate expired on " + this.getNotAfter());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.getNotBefore());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.cert.getSignatureValue().getBytes();
    }

    @Override
    public final void verify(PublicKey key, String provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.cert.getSignatureAlgorithm().equals(this.cert.getAcinfo().getSignature())) {
            throw new CertificateException("Signature algorithm in certificate info not same as outer certificate");
        }
        Signature signature = Signature.getInstance(this.cert.getSignatureAlgorithm().getObjectId().getId(), provider);
        signature.initVerify(key);
        try {
            signature.update(this.cert.getAcinfo().getEncoded());
        }
        catch (IOException iOException) {
            throw new SignatureException("Exception encoding certificate info object");
        }
        if (!signature.verify(this.getSignature())) {
            throw new InvalidKeyException("Public key presented not for certificate signature");
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.cert.getEncoded();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        Extension ext;
        Extensions extensions = this.cert.getAcinfo().getExtensions();
        if (extensions != null && (ext = extensions.getExtension(new ASN1ObjectIdentifier(oid))) != null) {
            try {
                return ext.getExtnValue().getEncoded("DER");
            }
            catch (Exception e2) {
                throw new RuntimeException("error encoding " + e2.toString());
            }
        }
        return null;
    }

    private Set getExtensionOIDs(boolean critical) {
        Extensions extensions = this.cert.getAcinfo().getExtensions();
        if (extensions != null) {
            HashSet<String> set = new HashSet<String>();
            Enumeration e2 = extensions.oids();
            while (e2.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e2.nextElement();
                Extension ext = extensions.getExtension(oid);
                if (ext.isCritical() != critical) continue;
                set.add(oid.getId());
            }
            return set;
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extensions = this.getCriticalExtensionOIDs();
        return extensions != null && !extensions.isEmpty();
    }

    @Override
    public X509Attribute[] getAttributes() {
        ASN1Sequence seq = this.cert.getAcinfo().getAttributes();
        X509Attribute[] attrs = new X509Attribute[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            attrs[i2] = new X509Attribute(seq.getObjectAt(i2));
        }
        return attrs;
    }

    @Override
    public X509Attribute[] getAttributes(String oid) {
        ASN1Sequence seq = this.cert.getAcinfo().getAttributes();
        ArrayList<X509Attribute> list = new ArrayList<X509Attribute>();
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            X509Attribute attr = new X509Attribute(seq.getObjectAt(i2));
            if (!attr.getOID().equals(oid)) continue;
            list.add(attr);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new X509Attribute[list.size()]);
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof X509AttributeCertificate)) {
            return false;
        }
        X509AttributeCertificate other = (X509AttributeCertificate)o2;
        try {
            byte[] b1 = this.getEncoded();
            byte[] b2 = other.getEncoded();
            return Arrays.areEqual(b1, b2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Arrays.hashCode(this.getEncoded());
        }
        catch (IOException iOException) {
            return 0;
        }
    }
}

