/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CertConfirmContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CertStatus;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.cmp.CMPException;
import com.timevale.tgtext.bouncycastle.cert.cmp.CertificateConfirmationContent;
import com.timevale.tgtext.bouncycastle.cert.cmp.a;
import com.timevale.tgtext.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.timevale.tgtext.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CertificateConfirmationContentBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private List acceptedCerts = new ArrayList();
    private List acceptedReqIds = new ArrayList();

    public CertificateConfirmationContentBuilder() {
        this(new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContentBuilder(DigestAlgorithmIdentifierFinder digestAlgFinder) {
        this.digestAlgFinder = digestAlgFinder;
    }

    public CertificateConfirmationContentBuilder addAcceptedCertificate(X509CertificateHolder certHolder, BigInteger certReqID) {
        this.acceptedCerts.add(certHolder);
        this.acceptedReqIds.add(certReqID);
        return this;
    }

    public CertificateConfirmationContent build(DigestCalculatorProvider digesterProvider) throws CMPException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.acceptedCerts.size(); ++i2) {
            DigestCalculator digester;
            X509CertificateHolder certHolder = (X509CertificateHolder)this.acceptedCerts.get(i2);
            BigInteger reqID = (BigInteger)this.acceptedReqIds.get(i2);
            AlgorithmIdentifier digAlg = this.digestAlgFinder.find(certHolder.toASN1Structure().getSignatureAlgorithm());
            if (digAlg == null) {
                throw new CMPException("cannot find algorithm for digest from signature");
            }
            try {
                digester = digesterProvider.get(digAlg);
            }
            catch (OperatorCreationException e2) {
                throw new CMPException("unable to create digest: " + e2.getMessage(), e2);
            }
            a.a(certHolder.toASN1Structure(), digester.getOutputStream());
            v2.add(new CertStatus(digester.getDigest(), reqID));
        }
        return new CertificateConfirmationContent(CertConfirmContent.getInstance(new DERSequence(v2)), this.digestAlgFinder);
    }
}

