/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.eac;

import java.io.UnsupportedEncodingException;

public class CertificateHolderReference {
    private static final String ReferenceEncoding = "ISO-8859-1";
    private String countryCode;
    private String holderMnemonic;
    private String sequenceNumber;

    public CertificateHolderReference(String countryCode, String holderMnemonic, String sequenceNumber) {
        this.countryCode = countryCode;
        this.holderMnemonic = holderMnemonic;
        this.sequenceNumber = sequenceNumber;
    }

    CertificateHolderReference(byte[] contents) {
        try {
            String concat = new String(contents, ReferenceEncoding);
            this.countryCode = concat.substring(0, 2);
            this.holderMnemonic = concat.substring(2, concat.length() - 5);
            this.sequenceNumber = concat.substring(concat.length() - 5);
            return;
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException(e2.toString());
        }
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getHolderMnemonic() {
        return this.holderMnemonic;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte[] getEncoded() {
        String ref = this.countryCode + this.holderMnemonic + this.sequenceNumber;
        try {
            return ref.getBytes(ReferenceEncoding);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException(e2.toString());
        }
    }
}

