/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.encrypt;

import com.yeepay.g3.sdk.yop.encrypt.DigestAlgEnum;
import com.yeepay.g3.sdk.yop.encrypt.Encodes;
import com.yeepay.g3.sdk.yop.exception.DecryptFailedException;
import com.yeepay.g3.sdk.yop.exception.EncryptFailedException;
import com.yeepay.g3.sdk.yop.exception.SignFailedException;
import com.yeepay.g3.sdk.yop.exception.VerifySignFailedException;
import com.yeepay.shade.com.google.common.base.Charsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RSA {
    private static final String RSA_ECB_PKCS1PADDING = "RSA/ECB/PKCS1Padding";
    private static final Map<DigestAlgEnum, String> SIGN_ALG_MAP = new HashMap<DigestAlgEnum, String>();

    public static boolean verifySign(byte[] data, byte[] sign, PublicKey publicKey, DigestAlgEnum digestAlg) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALG_MAP.get((Object)digestAlg));
            signature.initVerify(publicKey);
            signature.update(data);
            boolean result = signature.verify(sign);
            return result;
        }
        catch (Exception e) {
            throw new VerifySignFailedException("verifySign fail!", e);
        }
    }

    public static boolean verifySign(String data, String sign, PublicKey pubicKey, DigestAlgEnum digestAlg) {
        byte[] dataByte = data.getBytes(Charsets.UTF_8);
        byte[] signByte = Encodes.decodeBase64(sign);
        return RSA.verifySign(dataByte, signByte, pubicKey, digestAlg);
    }

    public static byte[] sign(byte[] data, PrivateKey key, DigestAlgEnum digestAlg) {
        try {
            Signature signature = Signature.getInstance(SIGN_ALG_MAP.get((Object)digestAlg));
            signature.initSign(key);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new SignFailedException("sign fail!", e);
        }
    }

    public static String sign(String data, PrivateKey key, DigestAlgEnum digestAlg) {
        byte[] dataByte = data.getBytes(Charsets.UTF_8);
        return Encodes.encodeUrlSafeBase64(RSA.sign(dataByte, key, digestAlg));
    }

    public static byte[] encrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1PADDING);
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptFailedException("rsa encrypt failed!", e);
        }
    }

    public static String encryptToBase64(String data, Key key) {
        try {
            return Encodes.encodeUrlSafeBase64(RSA.encrypt(data.getBytes(Charsets.UTF_8), key));
        }
        catch (Exception e) {
            throw new EncryptFailedException("rsa encrypt fail!", e);
        }
    }

    public static byte[] decrypt(byte[] data, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1PADDING);
            cipher.init(2, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new DecryptFailedException("rsa decrypt fail!", e);
        }
    }

    public static String decryptFromBase64(String data, Key key) {
        try {
            return new String(RSA.decrypt(Encodes.decodeBase64(data), key), Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new DecryptFailedException("rsa decrypt fail!", e);
        }
    }

    static {
        SIGN_ALG_MAP.put(DigestAlgEnum.SHA256, "SHA256withRSA");
        SIGN_ALG_MAP.put(DigestAlgEnum.SHA512, "SHA512withRSA");
    }
}

