/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime;

import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedDataParser;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEException;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEUtil;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.c;
import javax.activation.n;
import javax.mail.ad;
import javax.mail.d;
import javax.mail.internet.j;
import javax.mail.internet.k;
import javax.mail.internet.l;
import javax.mail.q;
import javax.mail.v;

public class SMIMESignedParser
extends CMSSignedDataParser {
    Object message;
    j content;

    private static InputStream getInputStream(v v2) throws q {
        try {
            if (v2.isMimeType("multipart/signed")) {
                throw new q("attempt to create signed data object from multipart content - use MimeMultipart constructor.");
            }
            return v2.getInputStream();
        }
        catch (IOException iOException) {
            throw new q("can't extract input stream: " + iOException);
        }
    }

    private static File getTmpFile() throws q {
        try {
            return File.createTempFile("bcMail", ".mime");
        }
        catch (IOException iOException) {
            throw new q("can't extract input stream: " + iOException);
        }
    }

    private static CMSTypedStream getSignedInputStream(d d2, String string, File file) throws q {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            SMIMEUtil.outputBodyPart(bufferedOutputStream, d2, string);
            ((OutputStream)bufferedOutputStream).close();
            a a2 = new a(file);
            return new CMSTypedStream(a2);
        }
        catch (IOException iOException) {
            throw new q("can't extract input stream: " + iOException);
        }
    }

    public SMIMESignedParser(l l2) throws q, CMSException {
        this(l2, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(l l2, File file) throws q, CMSException {
        this(l2, "7bit", file);
    }

    public SMIMESignedParser(l l2, String string) throws q, CMSException {
        this(l2, string, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, l l2) throws q, CMSException {
        this(l2, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, l l2, File file) throws q, CMSException {
        this(l2, "7bit", file);
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, l l2, String string) throws q, CMSException {
        this(digestCalculatorProvider, l2, string, SMIMESignedParser.getTmpFile());
    }

    public SMIMESignedParser(l l2, String string, File file) throws q, CMSException {
        super(SMIMESignedParser.getSignedInputStream(l2.a(0), string, file), SMIMESignedParser.getInputStream((v)l2.a(1)));
        this.message = l2;
        this.content = (j)l2.a(0);
        this.drainContent();
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, l l2, String string, File file) throws q, CMSException {
        super(digestCalculatorProvider, SMIMESignedParser.getSignedInputStream(l2.a(0), string, file), SMIMESignedParser.getInputStream((v)l2.a(1)));
        this.message = l2;
        this.content = (j)l2.a(0);
        this.drainContent();
    }

    public SMIMESignedParser(v v2) throws q, CMSException, SMIMEException {
        super(SMIMESignedParser.getInputStream(v2));
        this.message = v2;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toWriteOnceBodyPart(cMSTypedStream);
        }
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, v v2) throws q, CMSException, SMIMEException {
        super(digestCalculatorProvider, SMIMESignedParser.getInputStream(v2));
        this.message = v2;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toWriteOnceBodyPart(cMSTypedStream);
        }
    }

    public SMIMESignedParser(v v2, File file) throws q, CMSException, SMIMEException {
        super(SMIMESignedParser.getInputStream(v2));
        this.message = v2;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toMimeBodyPart(cMSTypedStream, file);
        }
    }

    public SMIMESignedParser(DigestCalculatorProvider digestCalculatorProvider, v v2, File file) throws q, CMSException, SMIMEException {
        super(digestCalculatorProvider, SMIMESignedParser.getInputStream(v2));
        this.message = v2;
        CMSTypedStream cMSTypedStream = this.getSignedContent();
        if (cMSTypedStream != null) {
            this.content = SMIMEUtil.toMimeBodyPart(cMSTypedStream, file);
        }
    }

    public j getContent() {
        return this.content;
    }

    public k getContentAsMimeMessage(ad ad2) throws q, IOException {
        if (this.message instanceof l) {
            d d2 = ((l)this.message).a(0);
            return new k(ad2, d2.getInputStream());
        }
        return new k(ad2, this.getSignedContent().getContentStream());
    }

    public Object getContentWithSignature() {
        return this.message;
    }

    private void drainContent() throws CMSException {
        try {
            this.getSignedContent().drain();
            return;
        }
        catch (IOException iOException) {
            throw new CMSException("unable to read content for verification: " + iOException, iOException);
        }
    }

    static {
        n n2 = (n)c.a();
        n2.d("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        n2.d("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        n2.d("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        n2.d("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        n2.d("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        c.a((c)n2);
    }

    private static class a
    extends BufferedInputStream {
        private final File a;

        a(File file) throws FileNotFoundException {
            super(new FileInputStream(file));
            this.a = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.a.delete();
        }
    }
}

