/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.config.provider;

import com.yeepay.g3.sdk.yop.config.AppSdkConfig;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProvider;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.provider.support.AppSdkConfigInitTask;
import com.yeepay.g3.sdk.yop.utils.CheckUtils;
import com.yeepay.g3.sdk.yop.utils.Holder;
import com.yeepay.shade.com.google.common.collect.Maps;
import com.yeepay.shade.org.apache.commons.lang3.BooleanUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFixedAppSdkConfigProvider
implements AppSdkConfigProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Holder<AppSdkConfig>> configs = Maps.newHashMap();
    private Holder<AppSdkConfig> defaultConfig = null;
    private volatile boolean init = false;

    @Override
    public final AppSdkConfig getConfig(String appKey) {
        Holder<AppSdkConfig> holder;
        if (!this.init) {
            this.init();
        }
        return (holder = this.configs.get(appKey)) == null ? null : holder.getValue();
    }

    @Override
    public final AppSdkConfig getDefaultConfig() {
        if (!this.init) {
            this.init();
        }
        return this.defaultConfig == null ? null : this.defaultConfig.getValue();
    }

    @Override
    public AppSdkConfig getConfigWithDefault(String appKey) {
        Holder<AppSdkConfig> holder;
        if (!this.init) {
            this.init();
        }
        return (holder = this.configs.get(appKey)) == null ? (this.defaultConfig == null ? null : this.defaultConfig.getValue()) : holder.getValue();
    }

    private synchronized void init() {
        if (this.init) {
            return;
        }
        List<SDKConfig> customSdkConfigs = this.loadCustomSdkConfig();
        if (customSdkConfigs == null || customSdkConfigs.size() == 0) {
            this.logger.warn("no custom sdkConfig provided.");
        } else {
            boolean hasDefault = false;
            for (SDKConfig sdkConfig : customSdkConfigs) {
                CheckUtils.checkCustomSDKConfig(sdkConfig);
                Holder<AppSdkConfig> holder = new Holder<AppSdkConfig>(new AppSdkConfigInitTask(sdkConfig));
                this.configs.put(sdkConfig.getAppKey(), holder);
                if (!BooleanUtils.isTrue(sdkConfig.getDefaulted()) || hasDefault) continue;
                this.defaultConfig = holder;
                hasDefault = true;
            }
            if (!hasDefault) {
                this.defaultConfig = this.configs.get(customSdkConfigs.get(0).getAppKey());
            }
        }
        this.init = true;
    }

    protected abstract List<SDKConfig> loadCustomSdkConfig();
}

