/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.demo;

import com.alibaba.fastjson.JSON;
import com.huifu.adapay.demo.BaseDemo;
import com.huifu.adapay.exception.BaseAdaPayException;
import com.huifu.adapay.model.DeviceInfo;
import com.huifu.adapay.model.payment.CurrencyEnum;
import com.huifu.adapay.model.payment.DeviceTypeEnum;
import com.huifu.adapay.model.payment.GoodsDetail;
import com.huifu.adapay.model.payment.PayChannelEnum;
import com.huifu.adapay.model.payment.Payment;
import com.huifu.adapay.model.payment.PaymentExpend;
import com.huifu.adapay.model.payment.PromotionDetail;
import java.util.ArrayList;
import java.util.HashMap;

public class PaymentDemo
extends BaseDemo {
    public static String executePaymentTest() throws Exception {
        PaymentDemo demo = new PaymentDemo();
        Payment payment = demo.executePayment();
        demo.queryPayment(payment.getId());
        demo.closePayment(payment.getId());
        return payment.getId();
    }

    public Payment executePayment() throws Exception {
        System.out.println("=======execute payment begin=======");
        HashMap<String, Object> paymentParams = new HashMap<String, Object>(10);
        paymentParams.put("app_id", "app_7d87c043-aae3-4357-9b2c-269349a980d6");
        paymentParams.put("order_no", "jsdk_payment_" + System.currentTimeMillis());
        paymentParams.put("pay_channel", PayChannelEnum.ALIPAY_QR.getCode());
        paymentParams.put("pay_amt", "0.01");
        paymentParams.put("currency", CurrencyEnum.CNY.getCode());
        paymentParams.put("goods_title", "your goods title");
        paymentParams.put("goods_desc", "your goods desc");
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDeviceType(DeviceTypeEnum.MOBILE.getCode());
        deviceInfo.setDeviceIp("127.0.0.1");
        paymentParams.put("device_info", deviceInfo);
        ArrayList<GoodsDetail> goodsDetailList = new ArrayList<GoodsDetail>();
        GoodsDetail goodsDetail = new GoodsDetail();
        goodsDetail.setGoodsId("your goods id");
        goodsDetail.setGoodsName("your goods name");
        goodsDetail.setQuantity("1");
        goodsDetail.setPrice("100.00");
        goodsDetailList.add(goodsDetail);
        PromotionDetail promotionDetail = new PromotionDetail();
        promotionDetail.setGoodsDetail(goodsDetailList);
        promotionDetail.setCostPrice("100.00");
        PaymentExpend expend = new PaymentExpend();
        expend.setPromotionDetail(promotionDetail);
        expend.setBuyerId("2088012928900274");
        expend.setBuyerLogonId("");
        paymentParams.put("expend", expend);
        Payment payment = null;
        try {
            payment = Payment.create(paymentParams);
        }
        catch (BaseAdaPayException e) {
            e.printStackTrace();
        }
        System.out.println("payment result=" + JSON.toJSONString((Object)payment));
        return payment;
    }

    public Payment closePayment(String paymentId) throws Exception {
        System.out.println("=======close payment begin=======");
        Payment payment = null;
        try {
            payment = Payment.close(paymentId);
        }
        catch (BaseAdaPayException e) {
            e.printStackTrace();
        }
        System.out.println("close payment result=" + JSON.toJSONString((Object)payment));
        return payment;
    }

    public Payment queryPayment(String paymentId) throws Exception {
        System.out.println("=======query payment begin=======");
        Payment payment = null;
        try {
            payment = Payment.query(paymentId);
        }
        catch (BaseAdaPayException e) {
            e.printStackTrace();
        }
        System.out.println("query payment result=" + JSON.toJSONString((Object)payment));
        return payment;
    }
}

