/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.tsa;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFailureInfo;
import com.timevale.tgtext.bouncycastle.asn1.tsp.TimeStampResp;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.tsp.TSPAlgorithms;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequest;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequestGenerator;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampResponse;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenInfo;
import esign.utils.exception.ag;
import esign.utils.exception.aj;
import esign.utils.security.tsa.c;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class b<T> {
    private static final Logger f = LoggerFactory.getLogger(b.class);
    protected List<T> a = new ArrayList<T>();
    protected String b;
    protected String c;
    protected String d;
    protected int e;
    private a<T> g;

    public b(List<T> urls, a<T> parser, String username, String password) {
        this(urls, (a<List<T>>)parser, username, password, (String)null, 0);
    }

    public b(T url, a<T> parser, String username, String password) {
        this(url, parser, username, password, null, 0);
    }

    public b(List<T> urls, a<T> parser, String username, String password, String proxyIp, int proxyPort) {
        this.a.addAll(urls);
        this.b = username;
        this.c = password;
        this.d = proxyIp;
        this.e = proxyPort;
        this.g = parser;
    }

    public b(T url, a<T> parser, String username, String password, String proxyIp, int proxyPort) {
        this.a.add(url);
        this.b = username;
        this.c = password;
        this.d = proxyIp;
        this.e = proxyPort;
        this.g = parser;
    }

    public void a(T url) {
        this.a.add(url);
    }

    public void a(List<T> urls) {
        this.a.addAll(urls);
    }

    public c<T> a(byte[] imprint) throws aj {
        if (this.a == null || this.a.isEmpty()) {
            f.error("tsa urls not config");
            throw ag.cq_.c();
        }
        for (T tsa : this.a) {
            byte[] data = null;
            String tsaUrl = this.g.a(tsa);
            try {
                data = this.b(tsaUrl, imprint);
            }
            catch (aj e2) {
                f.error("get timestamp from tsa failed. url:{}", (Object)tsaUrl);
                f.error("exception:", (Throwable)e2);
            }
            if (data == null) continue;
            c<T> info = new c<T>();
            info.a(data);
            info.a(tsa);
            return info;
        }
        throw ag.cr_.c();
    }

    /*
     * Loose catch block
     */
    public static boolean a(byte[] src, byte[] timestamp) {
        TimeStampResponse response;
        TimeStampResp resp;
        TimeStampRequest req;
        block15: {
            TimeStampRequestGenerator reqgen = new TimeStampRequestGenerator();
            req = reqgen.generate(TSPAlgorithms.SHA1, src);
            ASN1InputStream ans1 = new ASN1InputStream((InputStream)new ByteArrayInputStream(timestamp));
            resp = TimeStampResp.getInstance((Object)ans1.readObject());
            try {
                ans1.close();
            }
            catch (IOException iOException) {}
            break block15;
            catch (IOException e2) {
                try {
                    f.error("invalid timestamp.", (Throwable)e2);
                }
                catch (Throwable throwable) {
                    try {
                        ans1.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ans1.close();
                }
                catch (IOException iOException) {}
                return false;
            }
        }
        try {
            response = new TimeStampResponse(resp);
        }
        catch (TSPException e3) {
            f.error("invalid timestamp", (Throwable)e3);
            return false;
        }
        catch (IOException e4) {
            f.error("invalid timestamp", (Throwable)e4);
            return false;
        }
        try {
            response.validate(req);
            return true;
        }
        catch (TSPException tSPException) {
            f.error("validate timestamp failed.");
            return false;
        }
    }

    private byte[] b(String tsaUrl, byte[] imprint) throws aj {
        byte[] encoded;
        TimeStampResponse response;
        byte[] requestBytes;
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        TimeStampRequest request = tsqGenerator.generate(X509ObjectIdentifiers.id_SHA1, imprint, nonce);
        try {
            requestBytes = request.getEncoded();
        }
        catch (IOException e2) {
            f.error("get request encoded failed.", (Throwable)e2);
            throw ag.ag.a(e2);
        }
        byte[] respBytes = this.a(tsaUrl, requestBytes);
        try {
            response = new TimeStampResponse(respBytes);
        }
        catch (TSPException e3) {
            f.error("create time stamp response failed.", (Throwable)e3);
            throw ag.ag.a(e3);
        }
        catch (IOException e4) {
            f.error("create time stamp response failed.", (Throwable)e4);
            throw ag.ag.a(e4);
        }
        try {
            response.validate(request);
        }
        catch (TSPException e5) {
            f.error("validate tsa response failed.", (Throwable)e5);
            throw ag.ag.a(e5);
        }
        PKIFailureInfo failure = response.getFailInfo();
        int value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            f.error("tsa response validate failed. code:{}", (Object)value);
            throw ag.co_.a(value);
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            f.error("stamp token unexist. status:{}", (Object)response.getStatusString());
            throw ag.cp_.c();
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        try {
            encoded = tsToken.getEncoded();
        }
        catch (IOException e6) {
            f.error("get request encoded failed.", (Throwable)e6);
            throw ag.ag.a(e6);
        }
        f.info("Timestamp generated. token:{}, time:{}", (Object)encoded.length, (Object)tsTokenInfo.getGenTime());
        return respBytes;
    }

    protected byte[] a(String tsaUrl, byte[] requestBytes) throws aj {
        byte[] respBytes;
        URLConnection tsaConnection;
        URL url;
        f.info("get timestamp from tsa. url{}, proxy:{}:{}", new Object[]{tsaUrl, this.d, this.e});
        try {
            url = new URL(tsaUrl);
        }
        catch (MalformedURLException e2) {
            f.error("url invalid. url:{}", (Object)tsaUrl);
            f.error("exception:", (Throwable)e2);
            throw ag.bd.a(e2);
        }
        try {
            if (this.d != null && this.e != 0) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.d, this.e));
                tsaConnection = url.openConnection(proxy);
                tsaConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)");
            } else {
                tsaConnection = url.openConnection();
            }
        }
        catch (IOException ioe) {
            f.error("conntect to tsa failed. url:{}, proxy:{}:{}", new Object[]{tsaUrl, this.d, this.e});
            f.error("exception:", (Throwable)ioe);
            throw ag.ai.a(ioe);
        }
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setConnectTimeout(10000);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.b != null && !this.b.equals("")) {
            String userPassword = this.b + ":" + this.c;
            tsaConnection.setRequestProperty("Authorization", "Basic " + esign.utils.b.a(userPassword.getBytes()));
        }
        try {
            OutputStream out = tsaConnection.getOutputStream();
            out.write(requestBytes);
            out.close();
        }
        catch (IOException e3) {
            f.error("write data to tsa failed.", (Throwable)e3);
            throw ag.ai.a(e3);
        }
        try {
            int bytesRead;
            InputStream inp = tsaConnection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[10240];
            while ((bytesRead = inp.read(buffer, 0, 10240)) >= 0) {
                baos.write(buffer, 0, bytesRead);
            }
            respBytes = baos.toByteArray();
        }
        catch (IOException e4) {
            f.error("read data from tsa failed.", (Throwable)e4);
            throw ag.ag.a(e4);
        }
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            respBytes = esign.utils.b.a(new String(respBytes));
        }
        return respBytes;
    }

    public static interface a<T> {
        public String a(T var1);
    }
}

