/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERGeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.CertStatus;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponseData;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.RevokedInfo;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.SingleResponse;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLReason;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateStatus;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.cert.ocsp.RespID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.RevokedStatus;
import com.timevale.tgtext.bouncycastle.cert.ocsp.UnknownStatus;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BasicOCSPRespBuilder {
    private List list = new ArrayList();
    private Extensions responseExtensions = null;
    private RespID responderID;

    public BasicOCSPRespBuilder(RespID responderID) {
        this.responderID = responderID;
    }

    public BasicOCSPRespBuilder(SubjectPublicKeyInfo key, DigestCalculator digCalc) throws OCSPException {
        this.responderID = new RespID(key, digCalc);
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus) {
        this.list.add(new a(certID, certStatus, new Date(), null, null));
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Extensions singleExtensions) {
        this.list.add(new a(certID, certStatus, new Date(), null, singleExtensions));
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Date nextUpdate, Extensions singleExtensions) {
        this.list.add(new a(certID, certStatus, new Date(), nextUpdate, singleExtensions));
        return this;
    }

    public BasicOCSPRespBuilder addResponse(CertificateID certID, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, Extensions singleExtensions) {
        this.list.add(new a(certID, certStatus, thisUpdate, nextUpdate, singleExtensions));
        return this;
    }

    public BasicOCSPRespBuilder setResponseExtensions(Extensions responseExtensions) {
        this.responseExtensions = responseExtensions;
        return this;
    }

    public BasicOCSPResp build(ContentSigner signer, X509CertificateHolder[] chain, Date producedAt) throws OCSPException {
        DERBitString bitSig;
        Iterator it = this.list.iterator();
        ASN1EncodableVector responses = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                responses.add(((a)it.next()).a());
            }
            catch (Exception e2) {
                throw new OCSPException("exception creating Request", e2);
            }
        }
        ResponseData tbsResp = new ResponseData(this.responderID.toASN1Object(), new ASN1GeneralizedTime(producedAt), (ASN1Sequence)new DERSequence(responses), this.responseExtensions);
        try {
            OutputStream sigOut = signer.getOutputStream();
            sigOut.write(tbsResp.getEncoded("DER"));
            sigOut.close();
            bitSig = new DERBitString(signer.getSignature());
        }
        catch (Exception e3) {
            throw new OCSPException("exception processing TBSRequest: " + e3.getMessage(), e3);
        }
        AlgorithmIdentifier sigAlgId = signer.getAlgorithmIdentifier();
        DERSequence chainSeq = null;
        if (chain != null && chain.length > 0) {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            for (int i2 = 0; i2 != chain.length; ++i2) {
                v2.add(chain[i2].toASN1Structure());
            }
            chainSeq = new DERSequence(v2);
        }
        return new BasicOCSPResp(new BasicOCSPResponse(tbsResp, sigAlgId, bitSig, chainSeq));
    }

    private class a {
        CertificateID a;
        CertStatus b;
        DERGeneralizedTime c;
        DERGeneralizedTime d;
        Extensions e;

        public a(CertificateID certId, CertificateStatus certStatus, Date thisUpdate, Date nextUpdate, Extensions extensions) {
            RevokedStatus rs;
            this.a = certId;
            this.b = certStatus == null ? new CertStatus() : (certStatus instanceof UnknownStatus ? new CertStatus(2, DERNull.INSTANCE) : ((rs = (RevokedStatus)certStatus).hasRevocationReason() ? new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(rs.getRevocationTime()), CRLReason.lookup(rs.getRevocationReason()))) : new CertStatus(new RevokedInfo(new ASN1GeneralizedTime(rs.getRevocationTime()), null))));
            this.c = new DERGeneralizedTime(thisUpdate);
            this.d = nextUpdate != null ? new DERGeneralizedTime(nextUpdate) : null;
            this.e = extensions;
        }

        public SingleResponse a() throws Exception {
            return new SingleResponse(this.a.toASN1Object(), this.b, this.c, this.d, this.e);
        }
    }
}

