/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.spec;

import com.timevale.tgtext.bouncycastle.math.ec.ECCurve;
import java.math.BigInteger;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECNamedCurveSpec
extends ECParameterSpec {
    private String name;

    private static EllipticCurve convertCurve(ECCurve curve, byte[] seed) {
        if (curve instanceof ECCurve.Fp) {
            return new EllipticCurve(new ECFieldFp(((ECCurve.Fp)curve).getQ()), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
        }
        ECCurve.F2m curveF2m = (ECCurve.F2m)curve;
        if (curveF2m.isTrinomial()) {
            int[] ks = new int[]{curveF2m.getK1()};
            return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
        }
        int[] ks = new int[]{curveF2m.getK3(), curveF2m.getK2(), curveF2m.getK1()};
        return new EllipticCurve(new ECFieldF2m(curveF2m.getM(), ks), curve.getA().toBigInteger(), curve.getB().toBigInteger(), seed);
    }

    private static ECPoint convertPoint(com.timevale.tgtext.bouncycastle.math.ec.ECPoint g2) {
        return new ECPoint(g2.getX().toBigInteger(), g2.getY().toBigInteger());
    }

    public ECNamedCurveSpec(String name, ECCurve curve, com.timevale.tgtext.bouncycastle.math.ec.ECPoint g2, BigInteger n2) {
        super(ECNamedCurveSpec.convertCurve(curve, null), ECNamedCurveSpec.convertPoint(g2), n2, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, ECPoint g2, BigInteger n2) {
        super(curve, g2, n2, 1);
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, com.timevale.tgtext.bouncycastle.math.ec.ECPoint g2, BigInteger n2, BigInteger h2) {
        super(ECNamedCurveSpec.convertCurve(curve, null), ECNamedCurveSpec.convertPoint(g2), n2, h2.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, EllipticCurve curve, ECPoint g2, BigInteger n2, BigInteger h2) {
        super(curve, g2, n2, h2.intValue());
        this.name = name;
    }

    public ECNamedCurveSpec(String name, ECCurve curve, com.timevale.tgtext.bouncycastle.math.ec.ECPoint g2, BigInteger n2, BigInteger h2, byte[] seed) {
        super(ECNamedCurveSpec.convertCurve(curve, seed), ECNamedCurveSpec.convertPoint(g2), n2, h2.intValue());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

