/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.JcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.openssl.jcajce.a;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class JceOpenSSLPKCS8EncryptorBuilder {
    public static final String AES_128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES_192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES_256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String DES3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String PBE_SHA1_RC4_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC4.getId();
    public static final String PBE_SHA1_RC4_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC4.getId();
    public static final String PBE_SHA1_3DES = PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_2DES = PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC.getId();
    public static final String PBE_SHA1_RC2_128 = PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC.getId();
    public static final String PBE_SHA1_RC2_40 = PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC.getId();
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private AlgorithmParameters params;
    private ASN1ObjectIdentifier algOID;
    byte[] salt;
    int iterationCount;
    private Cipher cipher;
    private SecureRandom random;
    private AlgorithmParameterGenerator paramGen;
    private SecretKeyFactory secKeyFact;
    private char[] password;
    private SecretKey key;

    public JceOpenSSLPKCS8EncryptorBuilder(ASN1ObjectIdentifier algorithm) {
        this.algOID = algorithm;
        this.iterationCount = 2048;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setPasssword(char[] password) {
        this.password = password;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8EncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public OutputEncryptor build() throws OperatorCreationException {
        AlgorithmIdentifier algID;
        this.salt = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(this.salt);
        try {
            this.cipher = this.helper.createCipher(this.algOID.getId());
            if (a.a(this.algOID)) {
                this.paramGen = this.helper.createAlgorithmParameterGenerator(this.algOID.getId());
            } else {
                this.secKeyFact = this.helper.createSecretKeyFactory(this.algOID.getId());
            }
        }
        catch (GeneralSecurityException e2) {
            throw new OperatorCreationException(this.algOID + " not available: " + e2.getMessage(), e2);
        }
        if (a.a(this.algOID)) {
            this.params = this.paramGen.generateParameters();
            try {
                EncryptionScheme scheme = new EncryptionScheme(this.algOID, (ASN1Encodable)ASN1Primitive.fromByteArray(this.params.getEncoded()));
                KeyDerivationFunc func = new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(this.salt, this.iterationCount));
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                v2.add(func);
                v2.add(scheme);
                algID = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)new PBES2Parameters(new DERSequence(v2)));
            }
            catch (IOException e3) {
                throw new OperatorCreationException(e3.getMessage(), e3);
            }
            this.key = a.a(this.algOID.getId(), this.password, this.salt, this.iterationCount);
            try {
                this.cipher.init(1, (Key)this.key, this.params);
            }
            catch (GeneralSecurityException e4) {
                throw new OperatorCreationException(e4.getMessage(), e4);
            }
        }
        if (a.b(this.algOID)) {
            ASN1EncodableVector v3 = new ASN1EncodableVector();
            v3.add(new DEROctetString(this.salt));
            v3.add(new ASN1Integer(this.iterationCount));
            algID = new AlgorithmIdentifier(this.algOID, (ASN1Encodable)PKCS12PBEParams.getInstance(new DERSequence(v3)));
            try {
                PBEKeySpec pbeSpec = new PBEKeySpec(this.password);
                PBEParameterSpec defParams = new PBEParameterSpec(this.salt, this.iterationCount);
                this.key = this.secKeyFact.generateSecret(pbeSpec);
                this.cipher.init(1, (Key)this.key, defParams);
            }
            catch (GeneralSecurityException e5) {
                throw new OperatorCreationException(e5.getMessage(), e5);
            }
        } else {
            throw new OperatorCreationException("unknown algorithm: " + this.algOID, null);
        }
        return new OutputEncryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algID;
            }

            @Override
            public OutputStream getOutputStream(OutputStream encOut) {
                return new CipherOutputStream(encOut, JceOpenSSLPKCS8EncryptorBuilder.this.cipher);
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(algID, JceOpenSSLPKCS8EncryptorBuilder.this.key);
            }
        };
    }
}

