/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cgb.toolkit;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.x509.certificate.X509CRLFile;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class X509CertValidator {
    public static final int VERIFY_CERT_RESULT_VALID = 1;
    public static final int VERIFY_CERT_RESULT_NOT_YET_VALID = -1;
    public static final int VERIFY_CERT_RESULT_HAS_EXPIRED = -2;
    private static final Map trustCerts = new HashMap();

    public static void updateTrustCertsMap(ArrayList trustCertPaths) throws PKIException {
        if (trustCertPaths == null) {
            throw new IllegalArgumentException("null not allowed for trustCertPaths");
        }
        Iterator iterator = trustCertPaths.iterator();
        while (iterator.hasNext()) {
            X509CertValidator.updateTrustCertsMap((String)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTrustCertsMap(String trustCerPath) throws PKIException {
        if (trustCerPath == null) {
            throw new IllegalArgumentException("null not allowed for trustCerPath");
        }
        X509Cert cert = X509CertValidator.loadTrustCert(trustCerPath);
        Map map = trustCerts;
        synchronized (map) {
            trustCerts.put(cert.getSubject(), cert.getPublicKey());
            if (cert.getSubjectKeyIdentifier() != null) {
                try {
                    String id = Hex.toHexString(cert.getSubjectKeyIdentifier().getKeyIdentifier());
                    trustCerts.put(id, cert.getPublicKey());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static X509Cert loadTrustCert(String trustCerPath) throws PKIException {
        if (trustCerPath == null) {
            throw new IllegalArgumentException("null not allowed for trustCerPath");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(trustCerPath);
            X509Cert x509Cert = new X509Cert(fis);
            return x509Cert;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("update trust certificate failure", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTrustCertsMap() {
        Map map = trustCerts;
        synchronized (map) {
            trustCerts.clear();
        }
    }

    public static int verifyCertificate(byte[] certBytes) throws PKIException {
        if (1 == X509CertValidator.verifyCertDate(certBytes)) {
            if (X509CertValidator.validateCertSignature(certBytes)) {
                return 1;
            }
            return -1;
        }
        return -2;
    }

    public static boolean validateCertSignature(byte[] certBytes) throws PKIException {
        if (certBytes == null) {
            throw new IllegalArgumentException("null not allowed for certBytes");
        }
        X509Cert cert = new X509Cert(certBytes);
        PublicKey pubKey = null;
        if (cert.getAuthorityKeyIdentifier() != null) {
            try {
                String id = Hex.toHexString(cert.getAuthorityKeyIdentifier().getKeyIdentifier());
                pubKey = (PublicKey)trustCerts.get(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pubKey == null) {
            pubKey = (PublicKey)trustCerts.get(cert.getIssuer());
        }
        if (pubKey == null) {
            throw new PKIException("the ca trust certs is wrong,can not get the user cert's issuer");
        }
        return cert.verify(pubKey);
    }

    private static int verifyCertDate(byte[] certBytes) throws PKIException {
        if (certBytes == null) {
            throw new IllegalArgumentException("null not allowed for certBytes");
        }
        Date current = new Date();
        X509Cert cert = new X509Cert(certBytes);
        if (current.before(cert.getNotBefore())) {
            return -1;
        }
        if (current.after(cert.getNotAfter())) {
            return -2;
        }
        return 1;
    }

    public static boolean verifyCertByCRL(byte[] certBytes, String crlPath) throws PKIException {
        if (certBytes == null) {
            throw new IllegalArgumentException("null not allowed for certBytes");
        }
        if (crlPath == null) {
            throw new IllegalArgumentException("null not allowed for crlPath");
        }
        X509Cert cert = new X509Cert(certBytes);
        X509CRLFile crl = new X509CRLFile(crlPath, false);
        boolean valid = false;
        valid = !crl.isRevoke(cert.getSerialNumber());
        return valid;
    }
}

