/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.TBSCertificate;
import com.timevale.tgtext.bouncycastle.cert.CertException;
import com.timevale.tgtext.bouncycastle.cert.CertIOException;
import com.timevale.tgtext.bouncycastle.cert.a;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class X509CertificateHolder {
    private Certificate x509Certificate;
    private Extensions extensions;

    private static Certificate parseBytes(byte[] certEncoding) throws IOException {
        try {
            return Certificate.getInstance(ASN1Primitive.fromByteArray(certEncoding));
        }
        catch (ClassCastException e2) {
            throw new CertIOException("malformed data: " + e2.getMessage(), e2);
        }
        catch (IllegalArgumentException e3) {
            throw new CertIOException("malformed data: " + e3.getMessage(), e3);
        }
    }

    public X509CertificateHolder(byte[] certEncoding) throws IOException {
        this(X509CertificateHolder.parseBytes(certEncoding));
    }

    public X509CertificateHolder(Certificate x509Certificate) {
        this.x509Certificate = x509Certificate;
        this.extensions = x509Certificate.getTBSCertificate().getExtensions();
    }

    public int getVersionNumber() {
        return this.x509Certificate.getVersionNumber();
    }

    public int getVersion() {
        return this.x509Certificate.getVersionNumber();
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public List getExtensionOIDs() {
        return a.c(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return a.a(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return a.b(this.extensions);
    }

    public BigInteger getSerialNumber() {
        return this.x509Certificate.getSerialNumber().getValue();
    }

    public X500Name getIssuer() {
        return X500Name.getInstance(this.x509Certificate.getIssuer());
    }

    public X500Name getSubject() {
        return X500Name.getInstance(this.x509Certificate.getSubject());
    }

    public Date getNotBefore() {
        return this.x509Certificate.getStartDate().getDate();
    }

    public Date getNotAfter() {
        return this.x509Certificate.getEndDate().getDate();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.x509Certificate.getSubjectPublicKeyInfo();
    }

    public Certificate toASN1Structure() {
        return this.x509Certificate;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.x509Certificate.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.x509Certificate.getSignature().getBytes();
    }

    public boolean isValidOn(Date date) {
        return !date.before(this.x509Certificate.getStartDate().getDate()) && !date.after(this.x509Certificate.getEndDate().getDate());
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws CertException {
        ContentVerifier verifier;
        TBSCertificate tbsCert = this.x509Certificate.getTBSCertificate();
        if (!a.a(tbsCert.getSignature(), this.x509Certificate.getSignatureAlgorithm())) {
            throw new CertException("signature invalid - algorithm identifier mismatch");
        }
        try {
            verifier = verifierProvider.get(tbsCert.getSignature());
            OutputStream sOut = verifier.getOutputStream();
            DEROutputStream dOut = new DEROutputStream(sOut);
            dOut.writeObject(tbsCert);
            sOut.close();
        }
        catch (Exception e2) {
            throw new CertException("unable to process signature: " + e2.getMessage(), e2);
        }
        return verifier.verify(this.x509Certificate.getSignature().getBytes());
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof X509CertificateHolder)) {
            return false;
        }
        X509CertificateHolder other = (X509CertificateHolder)o2;
        return this.x509Certificate.equals(other.x509Certificate);
    }

    public int hashCode() {
        return this.x509Certificate.hashCode();
    }

    public byte[] getEncoded() throws IOException {
        return this.x509Certificate.getEncoded();
    }
}

