/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.core.util;

import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.exception.FailureCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLInitializationException;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static final ScheduledThreadPoolExecutor SCHEDULED = new ScheduledThreadPoolExecutor(1);
    private static PoolingHttpClientConnectionManager connManager;
    private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 30000;
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int MAX_IDLE_TIMEOUT = 30000;
    private static final int CLEAN_EXPIRE_INTERVAL = 5000;
    private static final int MAX_TOTAL = 300;
    private static final int MAX_PER_ROUTE = 100;
    private static final int MAX_TRY_TIMES = 3;
    private static final String ENCODING = "UTF-8";

    private static void cleanConnections(final PoolingHttpClientConnectionManager cm) {
        SCHEDULED.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (cm != null) {
                    cm.closeExpiredConnections();
                    cm.closeIdleConnections(30000L, TimeUnit.MILLISECONDS);
                }
            }
        }, 60000L, 5000L, TimeUnit.MILLISECONDS);
    }

    private static SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("SSLv3");
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
        sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        return sslContext;
    }

    public static CloseableHttpClient getHttpClient(int connectionRequestTimeout, int connectTimeout, int socketTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setRedirectsEnabled(true).build();
        HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).setRetryHandler(retryHandler).build();
    }

    public static String httpPost(String url, Map<String, Object> params, boolean isJson) throws BaseAdaPayException {
        return HttpClientUtils.httpPost(url, null, params, 10000, 30000, 30000, false, null, isJson, null, null);
    }

    public static String httpPost(String url, Map<String, String> headers, Map<String, Object> params) throws BaseAdaPayException {
        return HttpClientUtils.httpPost(url, headers, params, 10000, 30000, 30000, false, null, false, null, null);
    }

    public static String httpPostJson(String url, Map<String, String> headers, String json) throws BaseAdaPayException {
        return HttpClientUtils.httpPost(url, headers, null, 10000, 30000, 30000, false, json, true, null, null);
    }

    public static String httpPostFile(String url, Map<String, String> headers, Map<String, Object> params, File file, String fileParam) throws BaseAdaPayException {
        return HttpClientUtils.httpPost(url, headers, params, 10000, 30000, 60000, false, null, false, file, fileParam);
    }

    public static String httpPost(String url, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout, String json, boolean isJson) throws BaseAdaPayException {
        return HttpClientUtils.httpPost(url, null, params, connectionRequestTimeout, connectTimeout, socketTimeout, false, json, isJson, null, null);
    }

    public static String httpPost(String url, Map<String, String> headers, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout, boolean isStream, String json, boolean isJson, File file, String fileParam) throws BaseAdaPayException {
        HttpPost httpPost = new HttpPost(url);
        if (null != headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (file != null) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName(ENCODING));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart(fileParam, (ContentBody)new FileBody(file));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                builder.addTextBody(entry.getKey(), entry.getValue().toString(), ContentType.APPLICATION_FORM_URLENCODED.withCharset("utf-8"));
            }
            httpPost.setEntity(builder.build());
        }
        if (file == null && null != params) {
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpClientUtils.covertParams2NVPS(params), ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION);
            }
        }
        if (isJson && json != null && json.length() != 0) {
            StringEntity entity = new StringEntity(json, ENCODING);
            entity.setContentEncoding(ENCODING);
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpClientUtils.getResult((HttpRequestBase)httpPost, connectionRequestTimeout, connectTimeout, socketTimeout, isStream);
    }

    public static String httpGet(String url, Map<String, Object> params) throws BaseAdaPayException {
        return HttpClientUtils.httpGet(url, null, params, 10000, 30000, 30000, false);
    }

    public static String httpGet(String url, Map<String, String> headers, Map<String, Object> params) throws BaseAdaPayException {
        return HttpClientUtils.httpGet(url, headers, params, 10000, 30000, 30000, false);
    }

    public static String httpGet(String url, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout) throws BaseAdaPayException {
        return HttpClientUtils.httpGet(url, null, params, connectionRequestTimeout, connectTimeout, socketTimeout, false);
    }

    public static String httpGet(String url, Map<String, String> headers, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout, boolean isStream) throws BaseAdaPayException {
        HttpGet httpGet;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION);
        }
        if (null != params) {
            uriBuilder.setParameters(HttpClientUtils.covertParams2NVPS(params));
        }
        try {
            httpGet = new HttpGet(uriBuilder.build());
        }
        catch (Exception e) {
            throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION);
        }
        if (null != headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return HttpClientUtils.getResult((HttpRequestBase)httpGet, connectionRequestTimeout, connectTimeout, socketTimeout, isStream);
    }

    private static String getResult(HttpRequestBase httpRequest, int connectionRequestTimeout, int connectTimeout, int socketTimeout, boolean isStream) throws BaseAdaPayException {
        StringBuilder sb = new StringBuilder();
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpClient = HttpClientUtils.getHttpClient(connectionRequestTimeout, connectTimeout, socketTimeout);
            response = httpClient.execute((HttpUriRequest)httpRequest);
            int respCode = response.getStatusLine().getStatusCode();
            if (200 == respCode) {
                HttpEntity entity = response.getEntity();
                if (isStream) {
                    String len;
                    BufferedReader br = new BufferedReader(new InputStreamReader(entity.getContent(), ENCODING));
                    while ((len = br.readLine()) != null) {
                        sb.append(len);
                    }
                } else {
                    sb.append(EntityUtils.toString((HttpEntity)entity, (String)ENCODING));
                }
            } else {
                sb.append(response.getEntity() == null ? "" : EntityUtils.toString((HttpEntity)response.getEntity(), (String)ENCODING));
            }
        }
        catch (IOException | UnsupportedOperationException | ParseException e) {
            e.printStackTrace();
            throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION);
                }
            }
        }
        return sb.toString();
    }

    private static List<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        LinkedList<NameValuePair> paramList = new LinkedList<NameValuePair>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), null == entry.getValue() ? "" : entry.getValue().toString()));
        }
        return paramList;
    }

    static {
        if (connManager == null) {
            try {
                SSLContext sslContext = HttpClientUtils.getSSLContext();
                Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
                connManager = new PoolingHttpClientConnectionManager(registry);
                connManager.setMaxTotal(300);
                connManager.setDefaultMaxPerRoute(100);
                HttpClientUtils.cleanConnections(connManager);
            }
            catch (KeyManagementException | NoSuchAlgorithmException | SSLInitializationException e) {
                e.printStackTrace();
            }
        }
    }
}

