/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.adapay.AdaPay;
import com.huifu.adapay.exception.BaseAdaPayException;
import com.huifu.adapay.exception.FailureCode;
import com.huifu.adapay.util.AdaPaySign;
import com.huifu.adapay.util.HttpClientUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRequest {
    private static final String AUTHORIZATION = "Authorization";
    private static final String SIGNATURE = "Signature";

    protected static <T> T requestAdaPay(RequestMethod method, String uri, Map<String, Object> params, Class<T> clazz) throws BaseAdaPayException {
        boolean checkSign;
        String requestSign;
        if (AdaPay.apiKey == null || AdaPay.apiKey.length() == 0) {
            throw new BaseAdaPayException(FailureCode.CONFIG_EXCEPTION.getFailureCode(), "No API Key was provided.");
        }
        if (AdaPay.privateKey == null || AdaPay.privateKey.length() == 0 || AdaPay.pubKey == null || AdaPay.pubKey.length() == 0) {
            throw new BaseAdaPayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "No privatekey or publickey was provided.");
        }
        StringBuilder requestUrl = new StringBuilder(AdaPay.apiBase).append(uri);
        String back = null;
        HashMap<String, String> headers = new HashMap<String, String>(2);
        String originalStr = "";
        if (RequestMethod.POST == method) {
            originalStr = params.isEmpty() ? "" : JSONObject.toJSONString(params);
        } else if (RequestMethod.GET == method) {
            String string = originalStr = params.isEmpty() ? "" : AdaPaySign.getOriginalStr(params);
        }
        if (AdaPay.debug) {
            System.out.println("request string=" + originalStr);
        }
        try {
            requestSign = AdaPaySign.sign(requestUrl + originalStr, AdaPay.privateKey);
        }
        catch (Exception e) {
            requestSign = null;
        }
        if (requestSign == null || requestSign.length() == 0) {
            throw new BaseAdaPayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Sign error. Please check your privateKey.");
        }
        headers.put(AUTHORIZATION, AdaPay.apiKey);
        headers.put(SIGNATURE, requestSign);
        if (RequestMethod.POST == method) {
            headers.put("Content-type", "application/json");
            back = HttpClientUtils.httpPostJson(requestUrl.toString(), headers, originalStr);
        } else if (RequestMethod.GET == method) {
            back = HttpClientUtils.httpGet(requestUrl.toString(), headers, params);
        }
        if (AdaPay.debug) {
            System.out.println("post back=" + back);
        }
        if (back == null || back.length() == 0) {
            throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION.getFailureCode(), "Request no response. Please check your network.");
        }
        JSONObject jsonObject = JSON.parseObject((String)back);
        String data = jsonObject.getString("data");
        String signature = jsonObject.getString("signature");
        try {
            checkSign = AdaPaySign.verifySign(data, signature, AdaPay.pubKey);
        }
        catch (Exception e) {
            checkSign = false;
        }
        if (!checkSign) {
            throw new BaseAdaPayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Response sign check error. Please check your pubkey.");
        }
        try {
            return (T)JSON.parseObject((String)data, clazz);
        }
        catch (Exception e) {
            throw new BaseAdaPayException(FailureCode.SYSTEM_EXCEPTION.getFailureCode(), "Parse response error." + e.getMessage());
        }
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

