/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.pqc.asn1.McElieceCCA2PrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.spec.McElieceCCA2PrivateKeySpec;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.PrivateKey;

public class BCMcElieceCCA2PrivateKey
implements CipherParameters,
PrivateKey {
    private static final long serialVersionUID = 1L;
    private String oid;
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private Permutation p;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;
    private McElieceCCA2Parameters mcElieceCCA2Params;

    public BCMcElieceCCA2PrivateKey(String oid, int n2, int k2, GF2mField field, PolynomialGF2mSmallM gp, Permutation p2, GF2Matrix h2, PolynomialGF2mSmallM[] qInv) {
        this.oid = oid;
        this.n = n2;
        this.k = k2;
        this.field = field;
        this.goppaPoly = gp;
        this.p = p2;
        this.h = h2;
        this.qInv = qInv;
    }

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeySpec keySpec) {
        this(keySpec.getOIDString(), keySpec.getN(), keySpec.getK(), keySpec.getField(), keySpec.getGoppaPoly(), keySpec.getP(), keySpec.getH(), keySpec.getQInv());
    }

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeyParameters params) {
        this(params.getOIDString(), params.getN(), params.getK(), params.getField(), params.getGoppaPoly(), params.getP(), params.getH(), params.getQInv());
        this.mcElieceCCA2Params = params.getParameters();
    }

    @Override
    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public int getT() {
        return this.goppaPoly.getDegree();
    }

    public GF2mField getField() {
        return this.field;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public Permutation getP() {
        return this.p;
    }

    public GF2Matrix getH() {
        return this.h;
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.qInv;
    }

    public String toString() {
        String result = "";
        result = result + " extension degree of the field      : " + this.n + "\n";
        result = result + " dimension of the code              : " + this.k + "\n";
        result = result + " irreducible Goppa polynomial       : " + this.goppaPoly + "\n";
        return result;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BCMcElieceCCA2PrivateKey)) {
            return false;
        }
        BCMcElieceCCA2PrivateKey otherKey = (BCMcElieceCCA2PrivateKey)other;
        return this.n == otherKey.n && this.k == otherKey.k && this.field.equals(otherKey.field) && this.goppaPoly.equals(otherKey.goppaPoly) && this.p.equals(otherKey.p) && this.h.equals(otherKey.h);
    }

    public int hashCode() {
        return this.k + this.n + this.field.hashCode() + this.goppaPoly.hashCode() + this.p.hashCode() + this.h.hashCode();
    }

    public String getOIDString() {
        return this.oid;
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.3.6.1.4.1.8301.3.1.3.4.2");
    }

    protected ASN1Primitive getAlgParams() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        PrivateKeyInfo pki;
        McElieceCCA2PrivateKey privateKey = new McElieceCCA2PrivateKey(new ASN1ObjectIdentifier(this.oid), this.n, this.k, this.field, this.goppaPoly, this.p, this.h, this.qInv);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.getOID(), (ASN1Encodable)DERNull.INSTANCE);
            pki = new PrivateKeyInfo(algorithmIdentifier, privateKey);
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            iOException.printStackTrace();
            return null;
        }
        try {
            byte[] encoded = pki.getEncoded();
            return encoded;
        }
        catch (IOException iOException) {
            IOException e3 = iOException;
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public String getFormat() {
        return null;
    }

    public McElieceCCA2Parameters getMcElieceCCA2Parameters() {
        return this.mcElieceCCA2Params;
    }
}

