/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.spec.ECCKeyGenParameterSpec;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.spec.McElieceCCA2ParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class McElieceKeyPairGeneratorSpi
extends KeyPairGenerator {
    public McElieceKeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class McEliece
    extends McElieceKeyPairGeneratorSpi {
        McElieceKeyPairGenerator kpg;

        public McEliece() {
            super("McEliece");
        }

        @Override
        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.kpg = new McElieceKeyPairGenerator();
            super.initialize(params);
            ECCKeyGenParameterSpec ecc = (ECCKeyGenParameterSpec)params;
            McElieceKeyGenerationParameters mccKGParams = new McElieceKeyGenerationParameters(new SecureRandom(), new McElieceParameters(ecc.getM(), ecc.getT()));
            this.kpg.init(mccKGParams);
        }

        @Override
        public void initialize(int keySize, SecureRandom random) {
            ECCKeyGenParameterSpec paramSpec = new ECCKeyGenParameterSpec();
            try {
                this.initialize(paramSpec);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                return;
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair generateKeyPair = this.kpg.generateKeyPair();
            McEliecePrivateKeyParameters sk = (McEliecePrivateKeyParameters)generateKeyPair.getPrivate();
            McEliecePublicKeyParameters pk = (McEliecePublicKeyParameters)generateKeyPair.getPublic();
            return new KeyPair(new BCMcEliecePublicKey(pk), new BCMcEliecePrivateKey(sk));
        }
    }

    public static class McElieceCCA2
    extends McElieceKeyPairGeneratorSpi {
        McElieceCCA2KeyPairGenerator kpg;

        public McElieceCCA2() {
            super("McElieceCCA-2");
        }

        public McElieceCCA2(String s2) {
            super(s2);
        }

        @Override
        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.kpg = new McElieceCCA2KeyPairGenerator();
            super.initialize(params);
            ECCKeyGenParameterSpec ecc = (ECCKeyGenParameterSpec)params;
            McElieceCCA2KeyGenerationParameters mccca2KGParams = new McElieceCCA2KeyGenerationParameters(new SecureRandom(), new McElieceCCA2Parameters(ecc.getM(), ecc.getT()));
            this.kpg.init(mccca2KGParams);
        }

        @Override
        public void initialize(int keySize, SecureRandom random) {
            McElieceCCA2ParameterSpec paramSpec = new McElieceCCA2ParameterSpec();
            try {
                this.initialize(paramSpec);
                return;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                return;
            }
        }

        @Override
        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair generateKeyPair = this.kpg.generateKeyPair();
            McElieceCCA2PrivateKeyParameters sk = (McElieceCCA2PrivateKeyParameters)generateKeyPair.getPrivate();
            McElieceCCA2PublicKeyParameters pk = (McElieceCCA2PublicKeyParameters)generateKeyPair.getPublic();
            return new KeyPair(new BCMcElieceCCA2PublicKey(pk), new BCMcElieceCCA2PrivateKey(sk));
        }
    }
}

