/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileHelper {
    private static final int BUFFSIZE = 65536;

    private FileHelper() {
    }

    public static final void deleteFile(String fileName) {
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void write(String filePath, byte[] data) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("Illegal Argument: filePath");
        }
        if (data == null) {
            throw new IllegalArgumentException("Illegal Argument: data");
        }
        FileOutputStream fos = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            fos.write(data, 0, data.length);
            fos.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final byte[] read(String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("Illegal Argument: filePath");
        }
        FileInputStream crls = null;
        try {
            int rLength;
            crls = new FileInputStream(filePath);
            byte[] out = new byte[crls.available()];
            byte[] buffer = new byte[65536];
            int offset = 0;
            while ((rLength = crls.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
            byte[] byArray = out;
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (crls != null) {
                try {
                    crls.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final byte[] read(InputStream in) throws IOException {
        int rLength;
        if (in == null) {
            throw new IllegalArgumentException("Illegal Argument: in");
        }
        byte[] out = new byte[in.available()];
        byte[] buffer = new byte[65536];
        int offset = 0;
        while ((rLength = in.read(buffer, 0, buffer.length)) != -1) {
            System.arraycopy(buffer, 0, out, offset, rLength);
            offset += rLength;
        }
        return out;
    }
}

