/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.MessageEncryptor;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Vector;
import java.security.SecureRandom;

public class McEliecePKCSCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";
    private SecureRandom sr;
    private int n;
    private int k;
    private int t;
    public int maxPlainTextSize;
    public int cipherTextSize;
    McElieceKeyParameters key;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.sr = rParam.getRandom();
                this.key = (McEliecePublicKeyParameters)rParam.getParameters();
                this.initCipherEncrypt((McEliecePublicKeyParameters)this.key);
                return;
            }
            this.sr = new SecureRandom();
            this.key = (McEliecePublicKeyParameters)param;
            this.initCipherEncrypt((McEliecePublicKeyParameters)this.key);
            return;
        }
        this.key = (McEliecePrivateKeyParameters)param;
        this.initCipherDecrypt((McEliecePrivateKeyParameters)this.key);
    }

    public int getKeySize(McElieceKeyParameters key) {
        if (key instanceof McEliecePublicKeyParameters) {
            return ((McEliecePublicKeyParameters)key).getN();
        }
        if (key instanceof McEliecePrivateKeyParameters) {
            return ((McEliecePrivateKeyParameters)key).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    public void initCipherEncrypt(McEliecePublicKeyParameters pubKey) {
        this.sr = this.sr != null ? this.sr : new SecureRandom();
        this.n = pubKey.getN();
        this.k = pubKey.getK();
        this.t = pubKey.getT();
        this.cipherTextSize = this.n >> 3;
        this.maxPlainTextSize = this.k >> 3;
    }

    public void initCipherDecrypt(McEliecePrivateKeyParameters privKey) {
        this.n = privKey.getN();
        this.k = privKey.getK();
        this.maxPlainTextSize = this.k >> 3;
        this.cipherTextSize = this.n >> 3;
    }

    @Override
    public byte[] messageEncrypt(byte[] input) {
        GF2Vector m2 = this.computeMessageRepresentative(input);
        GF2Vector z2 = new GF2Vector(this.n, this.t, this.sr);
        GF2Matrix g2 = ((McEliecePublicKeyParameters)this.key).getG();
        Vector mG = g2.leftMultiply(m2);
        GF2Vector mGZ = (GF2Vector)mG.add(z2);
        return mGZ.getEncoded();
    }

    private GF2Vector computeMessageRepresentative(byte[] input) {
        byte[] data = new byte[this.maxPlainTextSize + ((this.k & 7) != 0 ? 1 : 0)];
        System.arraycopy(input, 0, data, 0, input.length);
        data[input.length] = 1;
        return GF2Vector.OS2VP(this.k, data);
    }

    @Override
    public byte[] messageDecrypt(byte[] input) throws Exception {
        GF2Vector vec = GF2Vector.OS2VP(this.n, input);
        McEliecePrivateKeyParameters privKey = (McEliecePrivateKeyParameters)this.key;
        GF2mField field = privKey.getField();
        PolynomialGF2mSmallM gp = privKey.getGoppaPoly();
        GF2Matrix sInv = privKey.getSInv();
        Permutation p1 = privKey.getP1();
        Permutation p2 = privKey.getP2();
        GF2Matrix h2 = privKey.getH();
        PolynomialGF2mSmallM[] qInv = privKey.getQInv();
        Permutation p3 = p1.rightMultiply(p2);
        Permutation pInv = p3.computeInverse();
        GF2Vector cPInv = (GF2Vector)vec.multiply(pInv);
        GF2Vector syndrome = (GF2Vector)h2.rightMultiply(cPInv);
        GF2Vector z2 = GoppaCode.syndromeDecode(syndrome, field, gp, qInv);
        GF2Vector mSG = (GF2Vector)cPInv.add(z2);
        mSG = (GF2Vector)mSG.multiply(p1);
        z2.multiply(p3);
        GF2Vector mS = mSG.extractRightVector(this.k);
        GF2Vector mVec = (GF2Vector)sInv.leftMultiply(mS);
        return this.computeMessage(mVec);
    }

    private byte[] computeMessage(GF2Vector mr) throws Exception {
        int index;
        byte[] mrBytes = mr.getEncoded();
        for (index = mrBytes.length - 1; index >= 0 && mrBytes[index] == 0; --index) {
        }
        if (mrBytes[index] != 1) {
            throw new Exception("Bad Padding: invalid ciphertext");
        }
        byte[] mBytes = new byte[index];
        System.arraycopy(mrBytes, 0, mBytes, 0, index);
        return mBytes;
    }
}

